### Name: objDS
### Title: Objective downscaling of monthly means
### Aliases: climate analysis objDS downscaling
### Keywords: models multivariate ts spatial

### ** Examples

## Not run: 
##D library(clim.pact)
##D oslo<-getnordklim("Oslo-Blindern")
##D slp.obs <- retrieve.nc("ncep_slp.nc")         # Get gridded observations/analysis from NCEP
##D slp.gcm <- retrieve.nc("EH4OPYC_B2_slp.nc")   # Get results from climate models
##D ds <- objDS(field.obs=slp.obs,field.gcm=slp.gcm,station=oslo)
##D 
##D t2m <- retrieve.nc("~/data/analysis/DNMI_t2m.nc")
##D t2m.gcm <- retrieve.nc("~/data/mpi/mpi-gsdio_t2m.nc",
##D            x.rng=range(t2m$lon),y.rng=range(t2m$lat))
##D ds <- objDS(field.obs=t2m,field.gcm=t2m.gcm,station=oslo)
## End(Not run)



