\name{cli.dat}
\docType{data}
\alias{cli.dat}
\title{Monthly climatic data of a single station}
\description{
  Monthly climatic data, for a single station, of average precipitation,
  average daily maxima and minima temperatures, and daily minima temperatures.
}
\usage{data(cli.dat)}
\format{A matrix of 4 lines (variables) and 12 columns (months) of data}
\source{Invented data for the example of \code{\link{diagwl}}}
\keyword{datasets}

\eof
\name{datest}
\alias{datest}
\title{Estimate series from their neighbors}
\description{
  Data of each series are estimated from all the other stations,
  through weighting averages of their data, standardized by the chosen method.
}
\usage{
  datest(verb = FALSE)
}
\arguments{
  \item{verb}{Verbose information about the progress of the operation}
}
\details{
  \code{datest} is an internal function used by \code{depudm}, not intended
  to be called directly by the user.
  It takes the data of the normalized series from object \code{dat.d}
  previously generated, and computes estimated data (dat.e) as averages,
  weighted by the weights est.w, of all the other stations.
}
\value{
  An object \code{dat.e}, with the estimated (normalized) data, is generated.
}
\seealso{\code{\link{depudm}}}
\keyword{internal}

\eof
\name{depstat}
\alias{depstat}
\title{Compute averages for a specified period}
\description{
  Listing of monthly and annual average values for a specified period,
  from data generated by \code{\link{depudm}}.
}
\usage{
  depstat(varcli, anyi, anyf, anyip = anyi, anyfp = anyf, nm = 12,
    ndec = 1, vala = 2)
}
\arguments{
  \item{varcli}{Acronym of the name of the studied climatic variable,
    as in the data file name.}
  \item{anyi}{Initial year of the data present in the file (four digits)}
  \item{anyf}{Final year of the data present in the file (four digits)}
  \item{anyip}{First year of the desired period (>=\code{anyi}, with 4 digits)}
  \item{anyfp}{Last year of the desired period (<=\code{anyf}, with 4 digits)}
  \item{nm}{Number of series in each station. (Default=12, for monthly data).}
  \item{ndec}{Number of decimal places to be saved in file
    \file{VAR\_AI-AF.dep}}
  \item{vala}{Kind of annual value:
    \describe{
      \item{1:}{Sum of monthly values,}
      \item{2:}{Average of monthly values,}
      \item{3:}{Maximum monthly value,}
      \item{4:}{Minimum monthly value.}
    }
  }
}
\details{
  Purged data are read from file \file{VAR\_AI-AF.dep}, generated by
  \code{\link{depudm}}, while the average data for the specified period
  (ai-af) are saved in \file{VAR\_ai-af.med}
}
\value{
  This function does not return any value.
}
\seealso{\code{\link{depudm}}}
\examples{
  #Function depudm must be run first (see the example), to create
  #  the file 'PTOT_51-00.dep'. Then you can run:
  \dontrun{depstat("PTOT",1951,2000,1971,2000,vala=1)}
  #See the results in the file 'PTOT_71-00.med' created by depstat.
}
\keyword{datagen}

\eof
\name{depudm}
\alias{depudm}
\title{Monthly data homogenization}
\description{
  Climatological series homogeneity studies, with missing data estimation,
  inhomogeneities (point errors, mean shifts and trends) detection, and
  graphical displays.
}
\usage{
  depudm(varcli, anyi, anyf, nm = 12, wa = 100, dz.max = 2, difumb = 0.05,
    leer = TRUE, a = 0, b = 1, wz=0.001, sqrtrans = FALSE, ttip = 3,
    refglob = FALSE, ndec = 1, pval = 0.05, graf = FALSE, auto = FALSE,
    verb=TRUE)
}
\arguments{
  \item{varcli}{Acronym of the name of the studied climatic variable,
    as in the data file name.}
  \item{anyi}{Initial year of the data present in the file (four digits)}
  \item{anyf}{Final year of the data present in the file (four digits)}
  \item{nm}{Number of series in each station. (Default=12, for monthly data).}
  \item{wa}{Shape parameter of the weighting function \code{1/(1+d^2/wa)},
    where d stands for distance. Low values (1-10) increase the weight of
    nearby stations, while high values (>1000) take in account also the
    far stations influence. Do \code{wa=0} if you want an unweighted average of
    all the stations.}
  \item{dz.max}{Threshold to accept differences between observed and estimated
    data, in standard deviation units. (Only used when \code{auto=TRUE}).}
  \item{difumb}{Maximum acceptable difference in the series average values
    between missing data filling iterations. This process will stop when
    the maximum difference is lower or equal to \code{difumb}.}
  \item{leer}{if \code{TRUE}, climatological data will be read from files.
    (Can be set to \code{FALSE} if data have already been read in a previous
    call to \code{depudm}).}
  \item{a, b}{Parameters of the optional transformation \code{a+b*dat} to be
    applied to data when read from the files.}
  \item{wz}{Scale parameter of the vertical coordinate \code{Z}. The default
    value assumes that \code{X} and \code{Y} are expressed in km, while
    \code{Z} is expressed in m.  Can be used to change the \code{Z} weight in
    inter-station distance computations.}
  \item{sqrtrans}{if \code{TRUE}, a square root transformation will  be applied
    to all data greater than 1. (Useful with e.g. precipitation data, to
    approximate their distribution to a Gauss one).}
  \item{ttip}{Type of standardization:
    \describe{
      \item{0:}{none,}
      \item{1:}{deviations from the mean,}
      \item{2:}{proportions of the mean (only for means greater than 1),}
      \item{3:}{full standardization (subtract the mean and divide by the
        standard deviation).}
    }
  }
  \item{refglob}{if \code{TRUE}, use annual averages for normalization of all
    the series of each station. Incompatible with \code{graf=TRUE}. Can be
    useful in arid places with frequent null precipitation mixed with high
    precipitation values in other years, making quite unstable the computation
    of their averages.}
  \item{ndec}{Number of decimal places of the purged data, to be saved in
    the file \file{VAR\_AI-AF.dep}.}
  \item{pval}{If greater than 0, t-test of mean difference will be applied
    to running windows of 10 and 20 terms (between samples of 5 and 10 terms),
    and an overall trend test. If \code{graf=TRUE}, p-values of the t-test
    will be plotted and, provided that the trend is significant (lower than
    \code{pval}), the regression line with time will be plotted as well.}
  \item{graf}{If \code{TRUE}, interactive graphs will be displayed for each
    series.}
  \item{auto}{If \code{TRUE}, data whose differences to their estimated
    (normalized) values are greater than \code{dz.max} will be substituted by
    their estimates.} \item{verb}{If \code{TRUE}, progress indications will be
    shown in the terminal.}
}
\details{
  This is the main function for error correction and homogeneity testing of the
  climatological series, and makes frequent calls to other subordinated
  functions.  The climatological series are read from files named
  \file{VAR\_AI-AF.dat}, and the coordinates and names of the stations from
  \file{VAR\_AI-AF.est}, where \code{VAR} stands for any acronym of the
  involved climatological variable, and \code{AI} and \code{AF} are the two
  last digits of the initial and final year of the data. Data are stored
  station by station, and chronologically within each station block.  Missing
  values are specified as \code{NA} (the usual way in R). In the stations file
  there will be a record (line) for each station, with structure \code{X Y Z ID
  NAME}, where \code{X} and \code{Y} are the UTM coordinates in km, \code{Z}
  the altitude in m, \code{ID} a station identifier, followed by the full
  \code{NAME} of the station, that must be put between double quotes if it
  contains any space character (see the example files in the package's data
  directory).  \code{depudm} will save the purged, filled series in files
  \file{VAR\_AI-AF.dep}, eventually overwriting the pre-existing ones. (Rename
  them if results of different calls to \code{depudm} are to be saved). A log
  of each run will also be appended in a file named \file{climatol.log}.
}
\value{
  Objects created by this function (original data, \code{dat.d}; normalized
  data, \code{dat.z}; estimated data, \code{dat.e}; ...) will remain resident
  in the memory space during the rest of the R session while not explicitly
  removed, therefore been susceptible to apply on them all the extended
  variety of statistical and graphic functions available in R.
}
\references{
  Climatol: Software libre para la depuracin y homogeneizacin de datos
  climatolgicos. IV Congress of the Spanish Climatology Society (Santander,
  2-5 of November 2004).
}
\author{Jose A. Guijarro}
\note{
  As inhomogeneities in one series will affect other nearby series, making
  them suspects of inhomogeneity even if they are good, it is advisable to
  proceed step by step, beginning with a fairly high \code{wa} (>=1000) to
  only correct the most prominent errors, and successively repeat the
  process with decreasing values of \code{wa}.
}
\seealso{\code{\link{grafanom}}, \code{\link{grabeps}}, \code{\link{depstat}}}
\examples{
  #The two files PTOT_51-00.* of the package's data directory must be
  #  first copied to the working directory. Then run:
  \dontrun{depudm("PTOT",1951,2000,b=.1,ttip=2,sqrtrans=TRUE,graf=TRUE)}
}
\keyword{ts}
\keyword{misc}
\keyword{hplot}

\eof
\name{destipif}
\alias{destipif}
\title{Series unstandardization}
\description{
  Undo the standardization performed by \code{tipif}.
}
\usage{
  destipif(ttip = 3)
}
\arguments{
  \item{ttip}{Type of standardization:
    \describe{
      \item{0:}{none,}
      \item{1:}{deviations from the mean,}
      \item{2:}{proportions of the mean (only for means greater than 1),}
      \item{3:}{full standardization (subtract the mean and divide by the
        standard deviation).}
    }
  }
}
\details{
  \code{destipif} is an internal function used by \code{depudm}, not intended
  to be called directly by the user.
  It takes the data from object \code{dat.d} previously created.
}
\value{
  Previously created object \code{dat.e} is unstandardized, using mean values
  (\code{dat.m}) and, eventually, standard deviations (\code{dat.s}).
}
\seealso{\code{\link{depudm}}}
\keyword{internal}

\eof
\name{diagwl}
\alias{diagwl}
\title{Walter \& Lieth climatic diagram}
\description{
  Plot of a Walter \& Lieth climatic diagram of a station.
}
\usage{
diagwl(dat, est = "", alt = NA, per = "", margen = c(4, 4, 5, 4), mlab = "",
  pcol = "#005ac8", tcol = "#e81800", pfcol = "cyan", sfcol = "#0eb6d7",
  shem = FALSE, ...)
}
\arguments{
  \item{dat}{Monthly climatic data on which the diagram will be plotted.}
  \item{est}{Name of the climatological station}
  \item{alt}{Altitude of the climatological station}
  \item{per}{Period of observation}
  \item{margen}{Margins vector for the plot (to be passed to \code{par}).}
  \item{mlab}{Month labels for the X axis:
    \describe{
      \item{"en":}{Month initials in English.}
      \item{"es":}{Month initials in Spanish.}
      \item{Other:}{Numeric labels (1-12).}
    }
  }
  \item{pcol}{Color pen for precipitation.}
  \item{tcol}{Color pen for temperature.}
  \item{pfcol}{Fill color for probable frosts.}
  \item{sfcol}{Fill color for sure frosts.}
  \item{shem}{Set to \code{TRUE} for southern hemisphere stations.}
  \item{\dots}{Other graphic parameters}
}
\details{
  Climatic data must be passed as a 4x12 matrix of monthly (January to
  December) data, in the following order:
  \describe{
    \item{Row 1:}{Mean precipitation}
    \item{Row 2:}{Mean maximum daily temperature}
    \item{Row 3:}{Mean minimum daily temperature}
    \item{Row 4:}{Absolute monthly minimum temperature}
  }
  This last row is only used to determine the probable frost months
  (when monthly values are equal or lower than 0C).
  If \code{shem=TRUE}, the diagram will begin the plot with the July data,
  to keep the summer period in the central zone of the graphic.
}
\value{
  No value is returned by this function.
}
\references{WALTER H & LIETH H (1960): Klimadiagramm Weltatlas. G. Fischer,
  Jena.}
\seealso{\code{\link{plot}}, \code{\link{par}}}
\examples{
  data(cli.dat)
  diagwl(cli.dat,est="Example station",alt=100,per="1961-90",mlab="en")
}
\keyword{hplot}

\eof
\name{grabeps}
\alias{grabeps}
\title{Save the displayed graphic as an EPS file}
\description{
  The last displayed graphic is saved in a file named \file{RAAMMDDHHMM-NN.eps}
  (in EPS format).
}
\usage{
  grabeps()
}
\details{
  \code{grabeps} is a function called by \code{grafanom}, but it can
  be called directly by the user.
  The name of the file saved begins by R, followed by digits indicating
  the year, month, day, hour and minute (two digits each) of the first
  call of this function in the present R session, plus a rank number
  (two digits also).
}
\value{
  No value is returned by this function.
}
\note{The last graphic will not be completely dumped to the file until the
  session ends.}
\seealso{\code{\link{grafanom}}}
\keyword{utilities}

\eof
\name{grafanom}
\alias{grafanom}
\title{Plot of anomalies, and original vs. estimated data}
\description{
  Plot of the standardized anomalies (original minus estimated data) and,
  optionally, original and estimated data (unstandardized).
}
\usage{
  grafanom(me=me, labm="", ttip=3, ndec=1, sqrtrans=FALSE, pval=.05)
}
\arguments{
  \item{me}{month (or sub-series number, if not monthly) to plot.}
  \item{labm}{month (or sub-series) label.}
  \item{ttip}{Type of standardization (to undo it for plotting the series).}
  \item{ndec}{Number of decimal places of the standard deviation label.}
  \item{sqrtrans}{Set to \code{TRUE} if a square root transformation was
    applied to the data (to undo it for plotting the series).}
  \item{pval}{If greater than 0, t-test of mean difference will be applied
    to moving windows of 10 and 20 terms (between samples of 5 and 10 terms),
    and an overall trend test. If \code{graf=TRUE}, p-values of the t-test
    will be plotted and, provided that the trend is significant (lower than
    \code{pval}), the regression line with time will be plotted as well.}
}
\details{
  \code{grafanom} is an internal function used by \code{depudm}, not intended
  to be called directly by the user.
  Anomalies are plotted centered on their own average.
  After displaying the plot, the user is prompted to enter the number of
  the station to jump to (RETURN will jump to the next), or to view the
  plot of the original and estimated series, save the graphic, or end.
  Graphics are saved in EPS format, in files named \file{RAAMMDDHHMM-NN.eps}:
  an initial R followed by digits indicating the year, month, day, hour
  and minute (two digits each) of the first call of this function in the
  present R session, plus a rank number (two digits also).
}
\value{
  No value is returned by this function.
}
\note{
  The last graphic will not be completely dumped to the file until the session
  ends.
}
\seealso{\code{\link{depudm}}, \code{\link{grabeps}}}
\keyword{internal}
\keyword{hplot}

\eof
\name{leerdm}
\alias{leerdm}
\title{Read the (monthly) climatological series}
\description{
  Climatological series, and coordinates and names of the stations, are
  read from \file{VAR\_AI-AF.dat} and \file{VAR\_AI-AF.est} files respectively.
}
\usage{
  leerdm(varcli, anyi, anyf, nm=12, b=1, a=0)
}
\arguments{
  \item{varcli}{Acronym of the name of the studied climatic variable,
    as in the data file name.}
  \item{anyi}{Initial year of the data present in the file (four digits)}
  \item{anyf}{Final year of the data present in the file (four digits)}
  \item{nm}{Number of series in each station. (Default=12, for monthly data).}
  \item{a, b}{Parameters of the optional transformation a+b*dat to be applied
    to data when read from the files.}
}
\details{
  \code{leerdm} is an internal function used by \code{depudm}, not intended
  to be called directly by the user.
}
\value{
  Objects \code{dat} (series data) and \code{est.c} (coordinates and names of
  the stations) are created, and number of years (\code{na}), number of
  stations (\code{ne}) and per station number of data (\code{nd}) are
  also computed.
}
\seealso{\code{\link{depudm}}}
\keyword{internal}

\eof
\name{matpesos}
\alias{matpesos}
\title{Inter-station weight matrix computation}
\description{
  Computation of the inter-station weight matrix that will be used by
  \code{datest} to estimate each station series from all other stations.
}
\usage{
  matpesos(wa=5, wz=.001, verb=TRUE)
}
\arguments{
  \item{wa}{Shape parameter of the weighting function \code{1/(1+d^2/wa)},
    where d stands for distance. Low values (1-10) increase the weight of
    nearby stations, while high values (>1000) take in account also the
    far stations influence. Do \code{wa=0} if you want an unweighted average of
    all the stations.}
  \item{wz}{Scale parameter of the vertical coordinate \code{Z}. The default
    value assumes that \code{X} and \code{Y} are expressed in km, while
    \code{Z} is expressed in m.  Can be used to change the \code{Z} weight in
    inter-station distance computations.}
  \item{verb}{If \code{TRUE}, progress indications will be shown in the
    terminal.}
}
\value{
  Object \code{est.w} is created, containing the computed weight matrix.
}
\seealso{\code{\link{depudm}}}
\keyword{internal}

\eof
\name{movttest}
\alias{movttest}
\title{t-test applied to a running window}
\description{
  A t-test of mean sample differences is successively applied to a window
  of \code{N} terms that runs along a series.
}
\usage{
  movttest(x, indme, nterm=10, pval=.05, verb=TRUE)
}
\arguments{
  \item{x}{Time series to be tested}
  \item{indme}{Label to identify the station and month (or sub-series)}
  \item{nterm}{Number of terms of the running window}
  \item{pval}{Significance threshold under which, provided that
    \code{verb=TRUE}, a line indicating the p-value and its position in
    the series will be shown.}
  \item{verb}{If \code{TRUE}, p-values under the threshold \code{pval} will be
    shown.}
}
\details{
  \code{movttest} is an internal function used by \code{depudm}, not intended
  to be called directly by the user.
  It is applied to a running window of \code{N} terms; therefore, the t-test is
  performed on the difference of the means of the first and last \code{N/2}
  terms of the window.
}
\value{
  An object \code{pv} is created, holding the p-values of all the t-test
  applied to the studied series.
}
\seealso{\code{\link{depudm}}, \code{\link{grafanom}}}
\keyword{internal}
\keyword{htest}
\keyword{ts}

\eof
\name{rosavent}
\alias{rosavent}
\title{Wind-rose plot}
\description{
  Plot of a wind-rose. Wind frequencies may be supplied by speed intervals,
  and can be absolute or relative.
}
\usage{
  rosavent(frec, fnum = 4, fint = 5, flab = 2, ang = 3 * pi/16,
    col = rainbow(10, 0.5, 0.92, start = 0.33, end = 0.2),
    margen = c(0, 0, 4, 0), key = TRUE, uni = "m/s", ...)
}
\arguments{
  \item{frec}{Wind frequencies.}
  \item{fnum}{Number of reference circumferences to plot.}
  \item{fint}{Frequency steps (in \%) between reference circumferences.}
  \item{flab}{
    Parameter indicating which circumferences must be labelled:
    \describe{
      \item{1:}{Label outer circumference only,}
      \item{2:}{Label all circumferences,}
      \item{Other value:}{Do not label any circumference.}
    }
  }
  \item{ang}{Angle along which circumferences will be labelled.}
  \item{col}{Colors to fill the frequency polygons.}
  \item{margen}{Margins vector for the plot (to be passed to \code{par}).}
  \item{key}{Set to FALSE if you do not want a legend of the wind-rose, that
    will otherwise be plotted if frequencies are supplied by speed intervals.}
  \item{uni}{Speed units for the legend header.}
  \item{\dots}{Other graphic parameters.}
}
\details{
  The number of direction classes is indifferent: As many as elements of the
  frequency vector (or columns of the matrix) will be considered, but the
  first element (column) must correspond to North.
  Frequencies will be converted to percentages, no matter how they were
  supplied.
}
\value{
  No value is returned by this function.
}
\seealso{\code{\link{plot}}, \code{\link{par}}}
\examples{
  data(windfreq.dat)
  rosavent(windfreq.dat,4,4,ang=-3*pi/16,main="Annual windrose")
}
\keyword{hplot}

\eof
\name{tipif}
\alias{tipif}
\title{Series standardization}
\description{
  Standardization of the series by the chosen method.
}
\usage{
  tipif(ttip = 3)
}
\arguments{
  \item{ttip}{Type of standardization:
    \describe{
      \item{0:}{none,}
      \item{1:}{deviations from the mean,}
      \item{2:}{proportions of the mean (only for means greater than 1),}
      \item{3:}{full standardization (subtract the mean and divide by the
        standard deviation).}
    }
  }
}
\details{
  \code{tipif} is an internal function used by \code{depudm}, not intended
  to be called directly by the user.
  It takes the data from object \code{dat.d} previously created.
}
\value{
  Standardized series \code{dat.z}, mean values \code{dat.m} and,
  optionally, standard deviations \code{dat.s} are created.
}
\seealso{\code{\link{depudm}}}
\keyword{internal}

\eof
\name{windfreq.dat}
\docType{data}
\alias{windfreq.dat}
\title{Wind frequency table}
\description{
  Wind frequency table for rosavent.R example.
}
\usage{data(windfreq.dat)}
\format{A table of 4 lines (speed intervals) and 16 columns (speed directions)
  of data, plus headers.}
\source{Invented data for the example of \code{\link{rosavent}}}
\keyword{datasets}

\eof
