\name{antifoul}
\docType{data}
\alias{antifoul}
\title{Dose-Response data for TBT and Zink Pyrithione in IPC-81 cells}
\description{
  This data set shows the response of the rat leukaemic cell line IPC-81 to 
  dilution series of tributyltin chloride (TBT) and Zink Pyrithione as retrieved
  from the "cytotox" database of the UFT Department of Bioorganic Chemistry on 
  February 25, 2004
}
\usage{data(antifoul)}
\format{
  A dataframe containing 135 and 81 data points for concentrations and responses
  for TBT and Zink Pyrithione, respectively. Additional data from the database is 
  also present.
}
\source{
  \url{http://www.uft.uni-bremen.de/chemie}
}
\keyword{datasets}

\eof
\name{checkplate}
\alias{checkplate}
\title{Check raw data from a specified microtiter plate}
\description{
  Report metadata from a specified microtiter plate from a specified database, box 
  plot positive and negative (blind) controls, and show the response data on the 
  plate.
}
\usage{
  checkplate(plate,db="cytotox")
}
\arguments{
  \item{plate}{
    The number of the plate identifying it within the database.}
  \item{db}{
    The database to be used. Currently only "cytotox" of the UFT Department of
    Bioorganic Chemistry is supported.}
}
\value{
  The function lists a report and shows two graphs.
}
\examples{
# Check plate number 1 in the cytotox database
\dontrun{data <- checkplate(1)}
}
\author{
  Johannes Ranke 
  \email{jranke@uni-bremen.de} 
  \url{http://www.uft.uni-bremen.de/chemie/ranke}
}
\keyword{database}

\eof
\name{drdata}
\alias{drdata}
\title{Get dose-response data}
\description{
	Get dose-response data from a remote mysql server 
}
\usage{
  drdata(substances, experimentator = "\%", db = "cytotox", celltype = "IPC-81", 
    whereClause = "1", ok = "'ok'")
}
\arguments{
  \item{substances}{
    A string or an array of strings with the substance names for
    which dose-response data is to be retrieved.}
  \item{experimentator}{
    The name of the experimentator whose data is to be used.}
  \item{db}{
    The database to be used. Currently only "cytotox" of the UFT Department of
    Bioorganic Chemistry is supported.}
  \item{celltype}{
    Currently, only data for IPC-81, C6, NB4, HeLa, Jurkat and U937 are supported.}
  \item{whereClause}{
    With this argument, additional conditions for the SQL query can be set, 
    e.g. "where plate != 710". The default is 1 (in SQL syntax this means TRUE).}
  \item{ok}{
    With the default value "'ok'", only data that has been checked and set to "ok"
    in the database is retrieved. Another sensible argument would be "'ok','?'", in 
    order to additionally retrieve data which has not yet been checked.}
}
\value{
  \item{data}{
    A data frame with a factor describing the dose levels, the numeric dose levels
    and a numeric column describing the response, as well as the entries for
    plate, experimentator, performed (date of test performance), celltype, unit
    (of the dose/concentration), and for the ok field in the database.}
}
\details{
  The function is currently only used for retrieving data from the
  mysql database "cytotox" of the UFT Department of Bioorganic Chemistry.
  Access to this database is limited to UFT staff.  Additionally to the
  installation of the RODBC package, it is required to set up a ODBC data
  source with the name "cytotox", using an ODBC driver for mysql, probably
  myODBC. Then, under Unix, you can use iodbc or unixodbc for setting up the
  respective data source with data source name (DSN) "cytotox". For my
  setting using unixodbc, I am using the file \file{/etc/odbcinst.ini}
  containing: 
  \tabular{lll}{
    [MySQL] \tab \tab \cr
    Description \tab = \tab MySQL driver for ODBC \cr
    Driver \tab = \tab /usr/local/lib/libmyodbc.so \cr
    Setup \tab = \tab /usr/lib/odbc/libodbcmyS.so \cr
  }
  and the file \file{/etc/odbc.ini} containing:
  \tabular{lll}{
    [cytotox] \tab \tab \cr
    Description \tab = \tab Cytotoxicity database of the department of bioorganic chemistry, UFT Bremen \cr
    Driver \tab = \tab MySQL \cr
    Trace \tab = \tab Yes  \cr
    TraceFile \tab = \tab /tmp/odbc.log  \cr
    Database \tab = \tab cytotox  \cr
    Server \tab = \tab eckehaat  \cr
    Port \tab = \tab 3306  \cr
  }.
}
\examples{
# Get cytotoxicity data for Tributyltin and zinc pyrithione, tested with IPC-81 cells
\dontrun{data <- drdata(c("TBT","Zn Pyrithion"))}
}
\author{
  Johannes Ranke 
  \email{jranke@uni-bremen.de} 
  \url{http://www.uft.uni-bremen.de/chemie/ranke}
}
\keyword{IO}
\keyword{database}

\eof
\name{drfit}
\alias{drfit}
\title{Fit dose-response models}
\description{
	Fit dose-response relationships to dose-response data and calculate
  biometric results for (eco)toxicity evaluation
}
\usage{
  drfit(data, startlogEC50 = NA, lognorm = TRUE, logis = FALSE, 
    linearlogis = FALSE, b0 = 2, f0 = 0)
}
\arguments{
  \item{data}{
    A data frame as returned from \code{\link{drdata}}.  The data frame has to
    contain at least a factor called "substance", a vector called "unit"
    containing the unit used for the dose, a column "response" with the
    response values of the test system normalized between 0 and 1 and a column
    "dose" with the numeric dose values. For later use of the
    \code{\link{drplot}} function, a factor called "dosefactor" also has to be
    present, containing the dose as a factor.
    }
  \item{startlogEC50}{
    Especially for the linearlogis model, a suitable log10 of the EC50 has to be given 
    by the user, since it is not correctly estimated for data showing hormesis with
    the default estimation method.}
  \item{lognorm}{
    A boolean defining if cumulative density curves of normal distributions
    are fitted to the data. Default ist TRUE.} 
  \item{logis}{
    A boolean defining if cumulative densitiy curves of logistic distributions
    are fitted to the data. Default is FALSE.} 
  \item{linearlogis}{
    A boolean defining if the linear-logistic function as defined by van Ewijk and Hoekstra
    1993 is fitted to the data. Default is FALSE.}
  \item{b0,f0}{
    If the linearlogistic model is fitted, b0 and f0 give the possibility to
    adapt the starting values for the parameters b and f.}
}
\value{
  \item{results}{
      A data frame containing at least one line for each substance. If the data did not
      show a mean response < 0.5 at the highest dose level, the modeltype is set to "none".
      Every successful fit is reported in one line. Parameters of the fitted curves are only
      reported if the fitted EC50 is not higher than the highest dose.}
    
} 
\examples{
data(antifoul)
r <- drfit(antifoul)
format(r,digits=2)
}
\author{
  Johannes Ranke 
  \email{jranke@uni-bremen.de} 
  \url{http://www.uft.uni-bremen.de/chemie/ranke}
}
\keyword{models}
\keyword{regression}
\keyword{nonlinear}

\eof
\name{drplot}
\alias{drplot}
\title{Plot dose-response models}
\description{
	Produce graphics of dose-response data and dose-response relationships 
  either combined or separately, for one or more substances.
}
\usage{
  drplot(drresults, data, dtype, alpha, path, fileprefix, overlay,
    postscript, color, datacolors, fitcolors)
}
\arguments{
  \item{drresults}{
    A data frame as returned from \code{\link{drfit}}.
    }
  \item{data}{ 
    A data frame as returned from \code{\link{drdata}}.  If data is to be
    plotted, the data frame has to contain at least a factor called
    "substance", a vector called "unit" containing the unit used for the dose,
    a column "response" with the response values of the test system normalized
    between 0 and 1, a column "dose" with the numeric dose values and a factor
    called "dosefactor" containing the dose as a factor. If plotting of the data is 
    not required, data can be set to FALSE.
    }
  \item{dtype}{
    A string describing if the raw data should be plotted ("raw"), or 
    an error bar should be constructed from the standard deviations of the
    responses at each dose level ("std", default value) or from the confidence
    intervals ("conf"). Of course, dtype only makes a difference, if a valid data
    object has been referenced.
    }
  \item{alpha}{
    The confidence level, defaulting to 0.95, only used if dtype "conf" has been
    chosen.
    }
  \item{path}{
    The path where graphic files should be put if any are produced. Defaults
    to "./" i.e. the current working directory of R.
    }
  \item{fileprefix}{
    A string which will form the beginning of each filename, if graphic files are 
    created. Defaults to "drplot".
    }
  \item{overlay}{
    If TRUE, all output will be put into one graph, otherwise a separate graph
    will be created for each substance. In the latter case, on-screen display
    (postscript=FALSE) only works correctly for data plots. Dose-response models
    will all be put into the last graph in this case.
    }
  \item{postscript}{
    If TRUE, (a) postscript graph(s) will be created. Otherwise, graphics will be
    displayed with a screen graphics device.
    }
  \item{color}{
    If TRUE, a sensible selection of colors will be attempted. If false, everything
    will be drawn in black
    }
  \item{datacolors}{
    This is a vector of colors, defaulting to 1:8, used for plotting the data.
    }
  \item{fitcolors}{
    Here you can specify a palette for the colors of the dose-response fits. The 
    default value is "default", which produces the default palette, if the 
    number of fits to be plotted is 8 or less. Otherwise, rainbow colors 
    will be plotted. Unless there is more than one fit per substance to be plotted,
    or the number of fits is larger than 8, the fitcolors will match the
    datacolors.
    }
}
\value{
  \item{results}{
    You will get plots of data and/or the fitted dose-response curves, on the
    screen and/or as postscript files, depending on the parameters.
    }
    
} 
\note{
  Turn off the colors if you don't like them and don't want to fiddle with
  them. Treatment of legends is quite bad. Be sure all devices are closed
  (e.g. by calling \code{dev.off()}) before calling \code{drplot} again.
}
\examples{
data(antifoul)
r <- drfit(antifoul)
\dontrun{drplot(r,antifoul)}
}
\author{
  Johannes Ranke 
  \email{jranke@uni-bremen.de} 
  \url{http://www.uft.uni-bremen.de/chemie/ranke}
}
\keyword{models}
\keyword{regression}
\keyword{nonlinear}

\eof
