### Name: plotcorr
### Title: Plot correlation matrix ellipses
### Aliases: plotcorr
### Keywords: hplot

### ** Examples

save.par <- par(ask = TRUE)    

# Plot the correlation matrix for the mtcars data full model fit 
data(mtcars)
fit <- lm(mpg ~ ., mtcars)
plotcorr(summary(fit, correlation = TRUE)$correlation)

# Plot a second figure with numbers in place of the
# ellipses
plotcorr(summary(fit, correlation = TRUE)$correlation, numbers = TRUE)

# Colour the ellipses to emphasize the differences
corr.mtcars <- cor(mtcars)
ord <- order(corr.mtcars[1,])
xc <- corr.mtcars[ord, ord]
plotcorr( xc, col=cm.colors(11)[5*xc + 6])

par(save.par)



