### Name: krige
### Title: Simple, Ordinary or Universal, global or local, Point or Block
###   Kriging
### Aliases: krige
### Keywords: models

### ** Examples

data(meuse)
data(meuse.grid)
m <- vgm(.59, "Sph", 874, .04)
# ordinary kriging:
x <- krige(log(zinc)~1, ~x+y, model = m, data = meuse, newd = meuse.grid)
levelplot(var1.pred~x+y, x, aspect = mapasp(x),
        main = "ordinary kriging predictions")
levelplot(var1.var~x+y, x, aspect = mapasp(x),
        main = "ordinary kriging variance")
# simple kriging:
x <- krige(log(zinc)~1, ~x+y, model = m, data = meuse, newdata = meuse.grid, 
        beta=5.9)
# residual variogram:
m <- vgm(.4, "Sph", 954, .06)
# universal block kriging:
x <- krige(log(zinc)~x+y, ~x+y, model = m, data = meuse, newdata = 
        meuse.grid, block = c(40,40))
levelplot(var1.pred~x+y, x, aspect = mapasp(x),
        main = "universal kriging predictions")
levelplot(var1.var~x+y, x, aspect = mapasp(x),
        main = "universal kriging variance")



