\name{align.pedigree}
\alias{align.pedigree}
\alias{alignped1}
\alias{alignped2}
\alias{alignped3}
\alias{alignped4}
\title{
  Generate plotting information for a pedigree
}
\description{
Given a pedigree, this function creates helper matrices that descibe
the layout of a plot of the pedigree.
}
\usage{
align.pedigree(ped, packed=T, hints=ped$hints, width=6, align=T)
}
\arguments{
\item{ped}{
a pedigree object
}
\item{packed}{
should the pedigree be compressed, i.e., to allow diagonal lines connecting
parents to children in order to have a smaller overall width for the plot.
}
\item{hints}{
two column hints matrix.  
The first column determines the relative order of subjects within a sibship,
as well as the relative order of processing for the founder couples.
(For this latter, the female founders are ordered as though they were sisters).
The second column contains spouse information, e.g., if hints[2,6] = 17,
then subject number 17 of the pedigree is a spouse of number 2, and is
preferentially plotted to the right of number 2.  Negative numbers plot
the spouse preferentially to the left.
}
\item{width}{
for a packed output, the minimum width
}
\item{align}{
should iterations of the `springs' algorithm be used to improve the plotted
output.  If True, a default number of iterations is used.  If numeric, this
specifies the number of iterations.
}
}
\value{
a structure with components
\item{n}{
a vector giving the number of subjects on each horizonal level of the
plot
}
\item{nid}{
a matrix with one row for each level, giving the numeric id of each subject
plotted.  (An value of 17 means the 17th subject in the pedigree).
}
\item{pos}{
a matrix giving the horizontal position of each plot point
}
\item{fam}{
a matrix giving the family id of each plot point.  A value of "3" would mean
that the two subjects in positions 3 and 4, in the row above, are this
subject's parents.
}
\item{spouse}{
a matrix with values 1= subject plotted to the immediate right is a spouse,
2= subject plotted to the immediate right is an inbred spouse, 0 = not a 
spouse
}
\item{twins}{
optional matrix which will only be present if the pedigree contains twins.
It has values 1= sibling to the right is a monozygotic twin, 2= sibling to
the right is a dizygotic twin, 3= sibling to the right is a twin of unknown
zygosity, 0 = not a twin
}
}
\details{
This is an internal routine, used almost exclusively by
\code{plot.pedigree}.
The subservient functions \code{alignped1}, 
\code{alignped2}, 
\code{alignped3}, 
and \code{alignped4} contain the bulk of the computation.
}
\seealso{
\code{\link{plot.pedigree}}
}
\keyword{array}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{as.matrix.bdsmatrix}
\alias{as.matrix.bdsmatrix}
\title{
a function for bdsmatrix
}
\description{
A function for bdsmatrix
}
\usage{
as.matrix.bdsmatrix(x)
}
\arguments{
\item{x}{a bdsmatrix}
}
\examples{
\dontrun{
# The function is currently defined as
function(x)
{
	if(class(x) != "bdsmatrix")
		stop("argument must be a bdsmatrix object")
	dd <- dim(x)
	d3 <- sum(x@blocksize)
	# dim of square portion
	d4 <- sum(x@blocksize^2)
	# size of x@blocks
	newmat <- matrix(0., dd[1], dd[2], dimnames = x@.Dimnames)
	temp <- .C("bdsmatrix_index1",
		as.integer(length(x@blocksize)),
		as.integer(x@blocksize),
		as.integer(c(1, 0, 0)),
		as.integer(d3),
		as.integer(1:d3 - 1),
		indexa = integer(d3 * d3),
		indexb = 0,
		indexc = 0)$indexa
	newmat[x@permute, x@permute] <- c(x@offdiag, x@blocks)[1 + temp]
	if(length(x@rmat) > 0) {
		newmat[,  - (1:d3)] <- x@rmat
		newmat[ - (1:d3),  ] <- t(x@rmat)
	}
	newmat
}
}
}
\keyword{array}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{autohint}
\alias{autohint}
\title{
  Align a pedigree to print well
}
\description{
A pedigree structure can contain a \code{hints} matrix
which helps to reorder the pedigree (e.g. left-to-right order of
children within family) so as to plot with minimal distortion.
This routine is called by the \code{pedigree} function
to create an intial hints matrix.
}
\usage{
autohint(ped)
}
\arguments{
\item{ped}{
a pedigree structure
}
}
\value{
a two column hints matrix
}
\details{
This routine would not normally be called by a user. 
It moves children within families, so that marriages are on the "edge"
of a set children, closest to the spouse.  
For pedigrees that have only a single connection between two families 
this simple-minded approach works surprisingly well.
For more complex structures either hand-tuning of the hints matrix, or
use of the \code{besthint} routine will usually
be required.
}
\seealso{
\code{\link{pedigree}, \link{besthint}}
}
\keyword{array}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{bdsBlock}
\alias{bdsBlock}
\title{
  Block diagonal matrices.
}
\description{
Create a block-diagonal matrix of ones.
}
\usage{
bdsBlock(id, group)
}
\arguments{
\item{id}{
the identifier list.  
This will become the dimnames of the final matrix, and must be a 
set of unique values.
It's length determines the dimension of the final matrix
}
\item{group}{
a vector giving the grouping structure.
All rows/cols belonging to a given group will form a block of 
1's in the final matrix.
}
}
\value{
a block-diagonal matrix of class \code{bdsmatrix}
}
\seealso{
\code{\link{bdsmatrix}, \link{bdsI}}
}
\examples{
\dontrun{
id    <- letters[1:10]
group <- c(1,1,3,2,3,3,2,3,2,4)
bdsBlock(id, group)
    a b d g i c e f h j 
  a 1 1 0 0 0 0 0 0 0 0
  b 1 1 0 0 0 0 0 0 0 0
  d 0 0 1 1 1 0 0 0 0 0
  g 0 0 1 1 1 0 0 0 0 0
  i 0 0 1 1 1 0 0 0 0 0
  c 0 0 0 0 0 1 1 1 1 0
  e 0 0 0 0 0 1 1 1 1 0
  f 0 0 0 0 0 1 1 1 1 0
  h 0 0 0 0 0 1 1 1 1 0
  j 0 0 0 0 0 0 0 0 0 1

# Create the matrices for a sparse nested fit of family within city
group <- paste(mydata$city, mydata$family, sep='/')
mat1 <- bdsI(group)
mat2 <- bdsBlock(group, mydata$city)
fit <- coxme(Surv(time, status) ~ age + sex, data=mydata,
               random= ~1|group, varlist=list(mat1, mat2))
}
}
\keyword{array}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{bdsI}
\alias{bdsI}
\title{
  Sparse identity matrices
}
\description{
This function will create an identitiy matrix, in the sparse
\code{bdsmatrix} format.
}
\usage{
bdsI(id, blocksize)
}
\arguments{
\item{id}{
the identifier list.  
This will become the dimnames of the final matrix, and must be a 
set of unique values.
It's length determines the dimension of the final matrix
}
\item{blocksize}{
the blocksize vector of the final matrix. 
If supplied, the sum of blocksizes must equal the dimension of the matrix. 
By default, the created matrix is as sparse as possible.
}
}
\value{
an identity matrix.
}
\examples{
imat <- bdsI(1:10)
}
}
\keyword{array}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{bdsmatrix-class}
\docType{class}
\alias{bdsmatrix-class}
\alias{\%*\%,matrix,bdsmatrix-method}
\alias{\%*\%,numeric,bdsmatrix-method}
\alias{Math2,bdsmatrix-method}
\alias{Math,bdsmatrix-method}
\alias{Ops,bdsmatrix,numeric-method}
\alias{Ops,bdsmatrix,bdsmatrix-method}
\alias{Ops,numeric,bdsmatrix-method}
\alias{[,bdsmatrix-method}
\alias{all,bdsmatrix-method}
\alias{any,bdsmatrix-method}
\alias{coerce,bdsmatrix,matrix-method}
\alias{coerce,bdsmatrix,vector-method}
\alias{diag,bdsmatrix-method}
\alias{diag<-,bdsmatrix-method}
\alias{dim,bdsmatrix-method}
\alias{dimnames,bdsmatrix-method}
\alias{dimnames<-,bdsmatrix-method}
\alias{max,bdsmatrix-method}
\alias{min,bdsmatrix-method}
\alias{prod,bdsmatrix-method}
\alias{range,bdsmatrix-method}
\alias{show,bdsmatrix-method}
\alias{sum,bdsmatrix-method}
\alias{unique,bdsmatrix,missing-method}

\title{Class "bdsmatrix" }
\description{ A bdsmarix class }
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("bdsmatrix", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{blocksize}:}{Object of class \code{"integer"} ~~ }
    \item{\code{blocks}:}{Object of class \code{"numeric"} ~~ }
    \item{\code{rmat}:}{Object of class \code{"matrix"} ~~ }
    \item{\code{offdiag}:}{Object of class \code{"numeric"} ~~ }
    \item{\code{.Dim}:}{Object of class \code{"integer"} ~~ }
    \item{\code{.Dimnames}:}{Object of class \code{"list or NULL"} ~~ }
  }
}
\section{Extends}{
Class \code{"matrix"}, directly.
}
\section{Methods}{
  \describe{
    \item{\%*\%}{\code{signature(x = "matrix", y = "bdsmatrix")}: ... }
    \item{\%*\%}{\code{signature(x = "numeric", y = "bdsmatrix")}: ... }
    \item{Math2}{\code{signature(x = "bdsmatrix")}: ... }
    \item{Math}{\code{signature(x = "bdsmatrix")}: ... }
    \item{Ops}{\code{signature(e1 = "bdsmatrix", e2 = "numeric")}: ... }
    \item{Ops}{\code{signature(e1 = "bdsmatrix", e2 = "bdsmatrix")}: ... }
    \item{Ops}{\code{signature(e1 = "numeric", e2 = "bdsmatrix")}: ... }
    \item{[}{\code{signature(x = "bdsmatrix")}: ... }
    \item{all}{\code{signature(na.rm = "bdsmatrix")}: ... }
    \item{any}{\code{signature(na.rm = "bdsmatrix")}: ... }
    \item{coerce}{\code{signature(from = "bdsmatrix", to = "matrix")}: ... }
    \item{coerce}{\code{signature(from = "bdsmatrix", to = "vector")}: ... }
    \item{diag}{\code{signature(x = "bdsmatrix")}: ... }
    \item{diag<-}{\code{signature(x = "bdsmatrix")}: ... }
    \item{dim}{\code{signature(x = "bdsmatrix")}: ... }
    \item{dimnames}{\code{signature(x = "bdsmatrix")}: ... }
    \item{dimnames<-}{\code{signature(x = "bdsmatrix")}: ... }
    \item{max}{\code{signature(na.rm = "bdsmatrix")}: ... }
    \item{min}{\code{signature(na.rm = "bdsmatrix")}: ... }
    \item{prod}{\code{signature(na.rm = "bdsmatrix")}: ... }
    \item{range}{\code{signature(na.rm = "bdsmatrix")}: ... }
    \item{show}{\code{signature(object = "bdsmatrix")}: ... }
    \item{sum}{\code{signature(na.rm = "bdsmatrix")}: ... }
    \item{unique}{\code{signature(x = "bdsmatrix", incomparables = "missing")}: ... }
  }
}

\keyword{classes}

\eof
\name{bdsmatrix}
\alias{bdsmatrix}
\alias{print.bdsmatrix}
\title{
  Create a sparse symmetric block diagonal matrix object
}
\description{
 Sparse block diagonal matrices are used in the the large parameter matrices
that can arise in random-effects coxph and survReg models.  This routine
creates such a matrix.  Methods for these matrices allow them to be 
manipulated much like an ordinary matrix, but the total memory use can be
much smaller.
}
\usage{
bdsmatrix(blocksize, blocks, rmat, dimnames)
}
\arguments{
\item{blocksize}{
 vector of sizes for the matrices on the diagonal
}
\item{blocks}{
 contents of the diagonal blocks, strung out as a vector
}
\item{rmat}{
 the dense portion of the matrix, forming a right and lower border
}
\item{dimnames}{
a list of dimension names for the matrix
}
}
\value{
an object of type bdsmatrix
}
\details{
Consider the following matrix, which has been divided into 4 parts.
\preformatted{
             1  2  0  0  0 | 4  5
	     2  1  0  0  0 | 6  7
	     0  0  3  1  2 | 8  8
	     0  0  1  4  3 | 1  1
	     0  0  2  3  5 | 2  2
	     --------------+-----
	     4  6  8  1  2 | 7  6
	     5  7  8  1  2 | 6  9
}
The upper left is block diagonal, and can be stored in a compressed form
without the zeros.  With a large number of blocks, the zeros can
actually account for over 99\% of a matrix; this commonly happens with
the kinship matrix for a large collection of families (one block/family).
The arguments to this routine would be block sizes of 2 and 3, along with
a 2 by 7 "right hand" matrix.  Since the matrix is symmetrical, the bottom
slice is not needed.
}
\examples{
# The matrix shown above is created by
tmat <- bdsmatrix(c(2,3), c(1,2,1, 3,1,2, 4,3, 5),
                  rmat=matrix(c(4,6,8,1,2,7,6, 5,7,8,1,2,6,9), ncol=2))

# Note that only the lower part of the blocks is needed, however, the
#  entire block set is also allowed, i.e., c(1,2,2,1, 3,1,2,1,4,3,2,3,5)
}
\keyword{manip}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{bdsmatrix.ibd}
\alias{bdsmatrix.ibd}
\title{
  Create a bdsmatrix from a list
}
\description{
Routines that create identity-by-descent (ibd) coefficients
often output their results as a list of values (i, j, x[i,j]),
with unlisted values of the x matrix assumed to be zero.
This routine recasts such a list into 
\code{bdsmatrix} form.
}
\usage{
bdsmatrix.ibd(id1, id2, x, idmap, diagonal)
}
\arguments{
\item{id1}{
row identifier for the value, in the final matrix.
Optionally, \code{id1} can be a 3 column
matrix or data.frame, in which case it is assumed to contain
the first 3 arguments, in order.
}
\item{id2}{
column identifier for the value, in the final matrix.
}
\item{x}{
the value to place in the matrix
}
\item{idmap}{
a two column matrix or data frame.
Sometimes routines create output with integer values for 
\code{id1} and \code{id2},
and then this argument is the mapping from this internal label to
the ``real'' name)
}
\item{diagonal}{
If diagonal elements are not preserved in the list, this value
will be used for the diagonal of the result.
If the argument appears, then the output matrix will contain
an entry for each value in \code{idlist}.
Otherwise only those with an explicit entry appear.
}
}
\value{
a \code{bdsmatrix} object representing a
block-diagonal sparse matrix.
}
\details{
The routine first checks for non-symmetric or otherwise inconsistent input.
It then groups observations together into `families' of
related subjects, which determines the structure of the final matrix.
As with the \code{makekinship} function, 
singletons with no relationships are first in the output matrix, and
then families appear one by one.
}
\seealso{
\code{\link{bdsmatrix}, \link{kinship}, \link{coxme}, \link{lmekin}}
}
\examples{
\dontrun{
ibdmat <- bdsmatrix.ibd(i,j, ibdval, idlist=subject)
}
}
\keyword{array}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{besthint}
\alias{besthint}
\title{
  Create a hints matrix for a pedigree.
}
\description{
A pedigree structure can contain a \code{hints} matrix
which helps to reorder the pedigree (e.g. left-to-right order of
children within family) so as to plot with minimal distortion.
This routine trys out a large number of configurations, finding the
best by brute force.
}
\usage{
besthint(ped, wt=c(1000, 10, 1), tolerance=0)
}
\arguments{
\item{ped}{
a pedigree object
}
\item{wt}{
relative weights for three types of "distortion" in a plotted pedigree.
The final score for a pedigree is the weighted sum of these; the lowest
score is considered the best.
The three components are 1: the number of dotted lines, connecting two
instances of the same person; 2: the lengths of those dotted lines; and
3: the horizontal offsets between parent/child pairs.
}
\item{tolerance}{
the threshold for acceptance.  
If any of the orderings that are attempted have a score that is less than
or equal to this value, the routine ceases searching for a better one.
}
}
\value{
a hints matrix
}
\details{
Assume that a pedigree has k founding couples, i.e., husband-wife pairs for
which neither has a parent in the pedigree.
The routine tries all k!/2 possible left to right orderings of the founders
(in random order), uses the \code{autohint} function
to optimize the order of children within each family, and computes a
score.
The hints matrix for the first pedigree to match the tolerance
level is returned, or that for the best score found if none match the
tolerance.
}
\seealso{
\code{\link{pedigree}, \link{plot.pedigree}, \link{autohint}}
}
\examples{
\dontrun{
# Find a good plot, only trying to avoid dotted connectors
myped$hints <- besthint(myped, wt=c(1000,100,0))
}
}
\keyword{array}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{coxme}
\alias{coxme}
\alias{coxme.fit}
\alias{coxme.varcheck}
\alias{print.coxme}
\title{
  Fit a mixed-effects Cox model
}
\description{
Returns an object of class \code{coxme} representing the
fitted model.
}
\usage{
coxme(fixed, data=parent.frame(), random, 
   weights, subset, na.action, init, control, 
   ties=c("efron", "breslow", "exact"), singular.ok=T, 
   varlist, variance, vinit=.2, sparse=c(50, .02), rescale=T, pdcheck=T, x=F, y=T, shortlabel=T,...)
}
\arguments{
\item{fixed}{
formula decribing the fixed effects part of the model.
}
\item{data}{
a data frame containing the variables.
}
\item{random}{
a one-sided formula describing the random effects part of the model.
}
\item{weights}{
case weights for each observation
}
\item{subset}{
an expression describing the subset of the data that should be used in the fit.
}
\item{na.action }{
a function giving the default action on encountering missing values.  
It is more usual to use the global na.action system option to control this.
}
\item{init}{
initial values for the coefficients for the fixed portion of the model, or 
the frailties followed by the fixed effect coefficients.
}
\item{control}{
the result of a call to \code{coxme.control}
}
\item{ties}{
the approximation to be used for tied death times: either "efron" or
"breslow"
}
\item{singular.ok }{
if TRUE, then redundant coefficients among the fixed effects are set to
NA, if FALSE the program will fail with an error message if there are
redundant variables.
}
\item{varlist}{
variance specifications, often of class \code{bdsmatrix},
decsribing the variance/covariance structure of one or more of the random
effects.  
}
\item{variance}{
fixed values for the variances of selected random effects.
Values of 0 indicate that the final value should be solved for.
}
\item{vinit}{
vector of initial values for variance terms.
It is necessary that the initial variance matrix be symmetric positive
definite.  Normally, a simple sum of the \code{varlist} matrices will
suffice, i.e., a vector of 1s; but not always.
}
\item{sparse}{
determines which levels of random effects factor variables, if any, 
for which the program will use sparse matrix techniques.
If a grouping variable has less than sparse[1] levels, then sparse methods
are not used for that variable.
If it has greater than or equal to sparse[1] unique levels, sparse methods
will be used for those values which represent less than sparse[2] as a 
proportion of the data. 
For instance, if a grouping variable has 4000 levels, but 40\% of the
subjects are in group 1 then 3999 of the levels will be represented sparsely
in the variance matrix. 
A single logical value of F is equivalent to setting sparse[1] to infinity.
}
\item{rescale}{
scale any user supplied variance matrices so as to have a diagonal of 1.0.
}
\item{pdcheck}{
verify that any user-supplied variance matrix is positive definite (SPD).
It has been observed that IBD matrices produced by some software are not
strictly SPD.  Sometimes models with these matrices still work (throughout
the iteration path, the weighted sum of variance matrices was always SPD)
and sometimes they don't.  In the latter case, messages about taking
the log of negative numbers will occur, and the results of the fit are
not necessarily trustworthy.
}
\item{x}{
retain the X matrix in the output.
}
\item{y}{
retain the dependent variable (a Surv object) in the output.
}
\item{shortlabel}{
no comment(s)
}
\item{...}{any other arguments}
}
\value{
an object of class coxme
}
\seealso{
\code{coxph}
}
\examples{
\dontrun{
coxme(Surv(time, status) ~ rx, data=rats, random= ~1|litter)

Cox mixed-effects kinship model fit by maximum likelihood
  Data: rats 
  n= 150 
                    NULL Integrated Penalized 
Log-likelihood -185.6556   -180.849  -173.774

  Penalized loglik: chisq= 23.76 on 13.17 degrees of freedom, p= 0.036 
 Integrated loglik: chisq= 9.61 on 2 degrees of freedom, p= 0.0082 

Fixed effects: Surv(time, status) ~ rx 
        coef exp(coef)  se(coef)        z         p 
rx 0.9132825  2.492491 0.3226856 2.830255 0.0046511

Random effects:  ~ 1 | litter 
             litter 
Variance: 0.4255484
}
}
\keyword{survival}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{coxme.control}
\alias{coxme.control}
\alias{strata2}
\title{
  Control parameters for coxme
}
\description{
Set various control parameters for the \code{coxme}
function.
}
\usage{
coxme.control(eps=0.00001, toler.chol=.Machine$double.eps^0.75, 
toler.ms=.01, inner.iter=4, 
iter.max=10, simplex=0, lower=1e-6, upper=Inf, sparse.calc=NULL )
}
\arguments{

\item{eps}{
convergence criteria for the inner Cox model computations.  
Iteration ceases when the relative change
in the log-likelihood is less than \code{eps}.
}
\item{toler.chol }{
tolerance that is used to detect singularity, i.e., redundant predictor
variables in the model, in the underlying Cholesky decompostion
routines.
}
\item{toler.ms }{
convergence criteria for the minimization of the integrated loglikelihood
over the variance parameters.
Since this ``outer'' iteration uses the Cox iteration as an inner loop,
and the Cox iteration in turn uses the cholesky decomposition as an inner
look, each of these treating the computations below it as if they were
exact, the cholesky tolerance should be tighter than the Cox tolerance,
which in turn should be tighter than that for the variance estimates.
}
\item{inner.iter }{
the number of iterations for the inner iteration loop.
}
\item{iter.max }{
maximum number of iterations for solution of a Cox partial
likelihood, given the values of the random effect variances.
Calls with \code{iter=0} are useful to
evaluate the likelihood for a prespecified parameter vector,
such as in the computation of a profile likelihood.
}
\item{simplex}{
number of iterations for the Nelder-Mead simplex algorithm.  
The simplex method is very good at finding the general neighborhood
of a minimum without getting lost, but can take a very large number
of iterations to narrow in on the final answer; 
opposite strentghs to the standard minimizer 
\code{optim}.
For hard problems, adding 50-100 iterations of the simplex as a
starting estimate for the usual method can be very helpful.
}
\item{lower, upper }{
limits for the variance parameters, used by optim.
}
\item{sparse.calc }{
style of computation for the inner likelihood code.  The results
of the two computations are identical, but can differ
in total compute time.  The optional calculation (calc=1)
uses somewhat more memory, but can be substantially faster when
the total number of random effects is of order n, the total
sample size.  The standard calculation (calc=0) is faster
when the number of random effects is small.
By default, the \code{coxme.fit} function chooses
the method dynamically.  
It may not always do so optimally.
}
}
\value{
a list containing values for each option.
}
\details{
The central computation consists of an outer maximization to
determine the variances of the random effects, performed by
the \code{optim} function.  
Each evaluation for optim, however, itself requires the
solution of a minimization problem; this is the inner loop.
It is important that the inner loop use a fixed number of
iterations, but it is not yet clear what is the minimal
sufficient number for that inner loop.  Making this number
smaller will make the routine faster, but perhaps at the
expense of accuracy.
}
\section{References}{
Therneau and Pankratz
}
\seealso{
\code{\link{coxme}}
}
\keyword{survival}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{familycheck}
\alias{familycheck}
\title{
  Error check for a family classification
}
\description{
Given a family id vector, also compute the familial grouping from
first principles using the parenting data, and compare the results.
}
\usage{
familycheck(famid, id, father.id, mother.id, newfam)
}
\arguments{
\item{famid}{
a vector of family identifiers
}
\item{id}{
a vector of unique subject identifiers
}
\item{father.id }{
vector containing the id of the biological father
}
\item{mother.id }{
vector containing the id of the biological mother
}
\item{newfam}{
the result of a call to \code{makefamid}.
If this has allready been computed by the user,
adding it as an argument shortens the running time somewhat.
}
}
\value{
a data frame with one row for each unique family id in the
\code{famid} argument.
Components of the output are


\item{famid}{
the family id, as entered into the data set
}
\item{n}{
number of subjects in the family
}
\item{unrelated}{
number of them that appear to be unrelated to anyone else 
in the entire pedigree set.  
This is usually marry-ins with no 
children (in the pedigree), and if so are not a problem.
}
\item{split}{
number of unique "new" family ids.
If this is 0, it means that no one in this "family" is related to
anyone else (not good); 
1 = everythings is fine;
2+= the family appears to be a set of disjoint trees.  Are you
                missing some of the people?
}
\item{join}{
number of other families that had a unique famid, but are actually
joined to this one.  0 is the hope.
If there are any joins, then an attribute "join" is attached.  It will be
a matrix with famid as row labels, new-family-id as the columns, and
the number of subjects as entries.  
}
}
\details{
The \code{makefamid} function is used to create a
de novo family id from the parentage data, and this is compared to the
family id given in the data.
}
\seealso{
\code{\link{makefamid}, \link{makekinship}}
}
\examples{
\dontrun{
#
# This is from a pedigree that had some identifier errors
#
> checkit<- familycheck(ids2$famid, ids2$gid, ids2$fatherid, ids2$motherid)
> table(checkit$split)    # should be all 1's
   0   1 2 
 112 424 4
# Shows 112 of the "families" were actually isolated individuals,
#  and that 4 of the families actually split into 2.  
#  In one case, a mistyped father id caused one child, along with his spouse
#  and children, to be "set adrift" from the connected pedigree.

> table(checkit$join)
   0 1 2 
 531 6 3
#
# There are 6 families with 1 other joined to them (3 pairs), and 3 with
#  2 others added to them (one triplet).
# For instance, a single mistyped father id of someone in family 319,
#  which was by bad luck the id of someone else in family 339,
#  was sufficient to join two groups.
> attr(checkit, 'join')
    [,1] [,2] [,3] [,4] [,5] [,6] [,7] 
 31   78    0    0    0    0    0    0
 32    3   15    0    0    0    0    0
 33    6    0   12    0    0    0    0
 63    0    0    0   63    0    0    0
 65    0    0    0   17   16    0    0
122    0    0    0    0    0   16    0
127    0    0    0    0    0   30    0
319    0    0    0    0    0    0   20
339    0    0    0    0    0    0   37
}
}
\keyword{manip}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{gchol-class}
\docType{class}
\alias{gchol-class}
\alias{coerce,gchol,matrix-method}
\alias{diag,gchol-method}
\alias{show,gchol-method}

\title{Class "gchol" }
\description{  a class of gchol }
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("gchol", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{.Data}:}{Object of class \code{"numeric"} ~~ }
    \item{\code{.Dim}:}{Object of class \code{"integer"} ~~ }
    \item{\code{.Dimnames}:}{Object of class \code{"list or NULL"} ~~ }
    \item{\code{rank}:}{Object of class \code{"integer"} ~~ }
  }
}
\section{Methods}{
  \describe{
    \item{coerce}{\code{signature(from = "gchol", to = "matrix")}: ... }
    \item{diag}{\code{signature(x = "gchol")}: ... }
    \item{show}{\code{signature(object = "gchol")}: ... }
  }
}

\keyword{classes}

\eof
\name{gchol-methods}
\docType{methods}
\alias{gchol-methods}
\alias{gchol,matrix-method}
\title{ Methods for Function gchol in Package `kinship'}
\description{gchol methods}
\section{Methods}{\describe{

\item{x = "matrix"}{ an ordinary matrix or bdsmatrix object }
}}
\keyword{methods}

\eof
\name{gchol}
\alias{gchol}
\alias{gchol.bdsmatrix}
\title{
  Generalized Cholesky decompostion
}
\description{
Perform the generalized Cholesky decompostion of a real symmetric matrix.
}
\usage{
gchol(x, tolerance=1e-10)
}
\arguments{
\item{x}{
the symmetric matrix to be factored
}
\item{tolerance}{
the numeric tolerance for detection of singular columns in x.
}
}
\value{
an object of class \code{gchol} containing the
generalized Cholesky decompostion.
It has the appearance of a lower triangular matrix.
}
\details{
A symmetric matrix A can be decomposed as LDL', where L is a lower
triangular matrix with 1's on the diagonal, L' is the transpose of
L, and D is diagonal.
The inverse of L is also lower-triangular, with 1's on the diagonal.  
If all elements of D are positive, then A must be symmetric
positive definite (SPD), and the solution can be reduced the usual
Cholesky decomposition U'U where U is upper triangular and
U = sqrt(D) L'.

The main advantage of the generalized form is that it admits
of matrices that are not of full rank: D will contain zeros 
marking the redundant columns, and the rank of A is the
number of non-zero columns.  If all elements of D are zero or
positive, then A is a non-negative definite (NND) matrix.
The generalized form also has the (quite minor) numerical advantage
of not requiring square roots during its calculation.
To extract the components of the decompostion, use the 
\code{diag} and \code{as.matrix}
functions.

The \code{solve} has a method for gchol decompostions,
and there are gchol methods for block diagonal symmetric
(\code{bdsmatrix}) matrices as well.
}
\seealso{
\code{\link{bdsmatrix}, \link{solve.gchol}}
}
\examples{
\dontrun{
# Create a matrix that is symmetric, but not positive definite
#   The matrix temp has column 6 redundant with cols 1-5
smat <- matrix(1:64, ncol=8)
smat <- smat + t(smat) + diag(rep(20,8))  #smat is 8 by 8 symmetric
temp <-  smat[c(1:5, 5:8), c(1:5, 5:8)]
ch1  <- gchol(temp)

print(as.matrix(ch1))   # print out L
print(diag(ch1))        # print out D
aeq <- function(x,y) all.equal(as.vector(x), as.vector(y))
aeq(diag(ch1)[6], 0)    # Check that it has a zero in the proper place

ginv <- solve(ch1)    # see if I get a generalized inverse
aeq(temp \%*\% ginv \%*\% temp, temp)
aeq(ginv \%*\% temp \%*\% ginv, ginv)
}
}
\keyword{array}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{gchol.bdsmatrix-class}
\docType{class}
\alias{gchol.bdsmatrix-class}
\alias{\%*\%,matrix,gchol.bdsmatrix-method}
\alias{\%*\%,numeric,gchol.bdsmatrix-method}
\alias{[,gchol.bdsmatrix-method}
\alias{coerce,gchol.bdsmatrix,matrix-method}
\alias{diag,gchol.bdsmatrix-method}
\alias{dim,gchol.bdsmatrix-method}
\alias{show,gchol.bdsmatrix-method}

\title{Class "gchol.bdsmatrix" }
\description{ an class generated from gchol(bdsmatrix object) }
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("gchol.bdsmatrix", ...)}.
    or gchol(bdsmatrix object)
}
\section{Slots}{
  \describe{
    \item{\code{blocksize}:}{Object of class \code{"integer"} ~~ }
    \item{\code{blocks}:}{Object of class \code{"numeric"} ~~ }
    \item{\code{rmat}:}{Object of class \code{"matrix"} ~~ }
    \item{\code{rank}:}{Object of class \code{"integer"} ~~ }
    \item{\code{.Dim}:}{Object of class \code{"integer"} ~~ }
    \item{\code{.Dimnames}:}{Object of class \code{"list or NULL"} ~~ }
  }
}
\section{Methods}{
  \describe{
    \item{\%*\%}{\code{signature(x = "matrix", y = "gchol.bdsmatrix")}: ... }
    \item{\%*\%}{\code{signature(x = "numeric", y = "gchol.bdsmatrix")}: ... }
    \item{[}{\code{signature(x = "gchol.bdsmatrix")}: ... }
    \item{coerce}{\code{signature(from = "gchol.bdsmatrix", to = "matrix")}: ... }
    \item{diag}{\code{signature(x = "gchol.bdsmatrix")}: ... }
    \item{dim}{\code{signature(x = "gchol.bdsmatrix")}: ... }
    \item{show}{\code{signature(object = "gchol.bdsmatrix")}: ... }
  }
}

\keyword{classes}

\eof
\name{kinship}
\alias{kinship}
\alias{kindepth}
\title{
  Compute a kinship matrix
}
\description{
Computes the n by n kinship matrix for a set of n related subjects
}
\usage{
kinship(id, father.id, mother.id)
}
\arguments{
\item{id}{
a vector of subject identifiers.  
It may be either numeric or character.
}
\item{father.id }{
for each subject, the identifier of the biological father.
}
\item{mother.id }{
for each subject, the identifier of the biological mother.
}
}
\value{
a matrix of kinship coefficients.
}
\details{
Two genes G1 and G2 are identical by descent (ibd) if they are both physical
copies of the same ancestral gene; two genes are identical by state if
they represent the same allele.  
So the brown eye gene that I inherited from my mother is ibd with hers;
the same gene in an unrelated individual is not.

The kinship coefficient between two subjects is the probability that a
randomly selected allele will be ibd between them.
It is obviously 0 between unrelated individuals. 
If there is no inbreeding in the pedigree, it will be .5 for an individual
with themselves (we could choose the same allele twice), .25 between mother
and child, etc.

The computation is based on a recursive algorithm described in Lange.
It is unfortunately not vectorizable, so the S code is slow.
For studies with multiple disjoint families see the 
\code{makekinship} routine.
}
\section{References}{
K Lange, Mathematical and Statistical Methods for Genetic Analysis,
Springer-Verlag, New York, 1997.
}
\seealso{
\code{\link{makekinship}, \link{makefamid}}
}
\examples{
\dontrun{
test1 <- data.frame(id  =c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14),
                    mom =c(0, 0, 0, 0, 2, 2, 4, 4, 6,  2,  0,  0, 12, 13),
                    dad =c(0, 0, 0, 0, 1, 1, 3, 3, 3,  7,  0,  0, 11, 10),
                    sex =c(0, 1, 0, 1, 0, 1, 0, 1, 0,  0,  0,  1,  1,  1))
round(8*kinship(test1$id, test1$dad, test1$mom))

   1 2 3 4 5 6 7 8 9 10 11 12 13 14 
 1 4 0 0 0 2 2 0 0 1  0  0  0  0  0
 2 0 4 0 0 2 2 0 0 1  2  0  0  0  1
 3 0 0 4 0 0 0 2 2 2  1  0  0  0  0
 4 0 0 0 4 0 0 2 2 0  1  0  0  0  0
 5 2 2 0 0 4 2 0 0 1  1  0  0  0  0
 6 2 2 0 0 2 4 0 0 2  1  0  0  0  0
 7 0 0 2 2 0 0 4 2 1  2  0  0  0  1
 8 0 0 2 2 0 0 2 4 1  1  0  0  0  0
 9 1 1 2 0 1 2 1 1 4  1  0  0  0  0
10 0 2 1 1 1 1 2 1 1  4  0  0  0  2
11 0 0 0 0 0 0 0 0 0  0  4  0  2  1
12 0 0 0 0 0 0 0 0 0  0  0  4  2  1
13 0 0 0 0 0 0 0 0 0  0  2  2  4  2
14 0 1 0 0 0 0 1 0 0  2  1  1  2  4
}
}
\keyword{array}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{kinship.ops}
\alias{\%*\%}
\alias{\%*\%.gchol.bdsmatrix}
\alias{\%*\%.default}
\alias{\%*\%.bdsmatrix}
\alias{\%*\%-methods}
\alias{\%*\%,ANY,ANY-method}
\alias{\%*\%,bdsmatrix-method}
\alias{\%*\%,bdsmatrix,numeric-method}
\alias{\%*\%,gchol.bdsmatrix-method}
\alias{\%*\%,gchol.bdsmatrix,numeric-method}
\alias{[.pedigree}
\alias{as.matrix.gchol}
\alias{as.matrix.gchol.bdsmatrix}
\alias{as.vector.bdsmatrix}
\alias{bdsmatrix.reconcile}
\alias{is.list.bdsmatrix}
\alias{is.matrix.bdsmatrix}
\alias{is.matrix.gchol.bdsmatrix}
\alias{is.bdsmatrix}
\alias{is.gchol.bdsmatrix}
\alias{is.list.gchol.bdsmatrix}
\title{Basic Linear Algebra for classes bdsmatrix and gchol.bdsmatrix}
\description{Basic linear algebra operators for class \code{bdsmatrix} and 
\code{gchol.bdsmatrix}}
\usage{ }
\keyword{algebra}

\eof
\name{list or NULL-class}
\docType{class}
\alias{list or NULL-class}

\title{Class "list or NULL" }
\description{ a class used in bdsmatrix}
\section{Objects from the Class}{A virtual Class: No objects may be created from it.}
\section{Methods}{
No methods defined with class "list or NULL" in the signature.
}

\keyword{classes}

\eof
\name{lmekin}
\alias{lmekin}
\alias{print.lmekin}
\alias{getCovariateFormula2}
\alias{getCrossedTerms}
\alias{getGroupsFormula2}
\title{
  Linear Mixed Effects model using a kinship matrix.
}
\description{
A similar function to lme, but allowing for a complete specification of the
covariance matrix for the random effects.
}
\usage{
lmekin(fixed, data=parent.frame(), random,
    varlist=NULL, variance, sparse=c(20, .05),
    rescale=T, pdcheck=T,
    subset, weight, na.action)
}
\arguments{
\item{fixed}{
model statement for the fixed effects
}
\item{random}{
model statement for the random effects
}
\item{data}{
data frame containing the variables
}
\item{varlist}{
variance specifications, often of class \code{bdsmatrix},
decsribing the variance/covariance structure of one or more of the random
effects.  
}
\item{variance}{
fixed values for the variances of selected random effects.
Values of 0 indicate that the final value should be solved for.
}
\item{sparse}{
determines which levels of random effects factor variables, if any, 
for which the program will use sparse matrix techniques.
If a grouping variable has less than sparse[1] levels, then sparse methods
are not used for that variable.
If it has greater than or equal to sparse[1] unique levels, sparse methods
will be used for those values which represent less than sparse[2] as a 
proportion of the data. 
For instance, if a grouping variable has 4000 levels, but 40\% of the
subjects are in group 1 then 3999 of the levels will be represented sparsely
in the variance matrix. 
A single logical value of F is equivalent to setting sparse[1] to infinity.
}
\item{rescale}{
scale any user supplied variance matrices so as to have a diagonal of 1.0.
}
\item{pdcheck}{
verify that any user-supplied variance matrix is positive definite (SPD).
It has been observed that IBD matrices produced by some software are not
strictly SPD.  Sometimes models with these matrices still work (throughout
the iteration path, the weighted sum of variance matrices was always SPD)
and sometimes they don't.  In the latter case, messages about taking
the log of negative numbers will occur, and the results of the fit are
not necessarily trustworthy.
}
\item{subset}{
selection of a subset of data
}
\item{weight}{
optional case weights
}
\item{na.action }{
the action for missing data values
}
}
\value{
an object of class 'lmekin', sharing similarities with both lm and lme
objects.
}
\details{
The lme function is designed to accept a prototype for the variance matrix
of the random effects, with the same prototype applying to all of the
groups in the data.  For familial genetic random effects, however, each
family has a different covariance pattern, necessitating the input of the
entire set of covariance matrices.  
In return, at present lmekin does not have the prototype abilities of lme.
}
\section{References}{
Pinheiro and Bates, Mixed Effect Models in S and Splus
}
\seealso{
\code{\link{print.lmekin}, lme}
}
\examples{
\dontrun{
#
# Make a kinship matrix for the entire study
# These two functions are NOT fast, the makekinship one in particular
#
cfam <- makefamid(main$gid, main$momid, main$dadid)
kmat <- makekinship(cfam, main$gid, main$momid, main$dadid)

# The kinship matrix for the females only: quite a bit smaller
#
kid <- dimnames(kmat)[[1]]
temp <- main$sex[match(kid, main$gid)] == 'F'
fkmat <- kmat[temp,temp]

# The dimnames on kmat are the gid value, which are necessary to match
#  the appropriate row/col of kmat to the analysis data set
# A look at \%dense tissue on a mammogram, with age at mammogram and
#  weight as covariates, and a familial random effect
#
fit <- lmekin(percdens ~ mammage + weight, data=anal1,
                 random = ~1|gid, varlist=list(fkmat))

Linear mixed-effects kinship model fit by maximum likelihood
  Data: anal1 
  Log-likelihood = -6093.917 
  n= 1535 

Fixed effects: percdens ~ mammage + weight 
 (Intercept)    mammage     weight 
     87.1593 -0.5333198 -0.1948871

Random effects:  ~ 1 | gid 
         Kinship Residual 
StdDev: 7.801603 10.26612
}
}
\keyword{regression}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{makefamid}
\alias{makefamid}
\title{
  Identify family groups
}
\description{
Given a set of parentage relationships, this subdivides a set of
subjects into families. 
}
\usage{
makefamid(id, father.id, mother.id)
}
\arguments{
\item{id}{
a vector of unique subject identifiers
}
\item{father.id }{
for each subject, the identifier of their biolgical father
}
\item{mother.id }{
for each subject, the identifier of thier biological mother
}
}
\value{
a vector of family identifiers.
Individuals who are not blood relatives of anyone else in the data
set as assigned a family id of 0.
}
\details{
This function may be useful to create a family identifier if none
exists in the data (rare),
to check for anomalies in a given family identifier
(see the \code{familycheck} function),
or to create a more space and time efficient kinship matrix by
separating out marry-ins without children as 'unrelated'.
}
\seealso{
\code{\link{makefamid}, \link{kinship}, \link{makekinship}}
}
\examples{
\dontrun{
> newid <- makefamid(cdata$gid, cdata$dadid, cdata$momid)
> table(newid==0)
 FALSE TRUE 
 17859 8191
# So nearly 1/3 of the individuals are not blood relatives.

> kin1 <- makekinship(cdata$famid, cdata$gid, cdata$dadid, cdata$momid)
> kin2 <- makekinship(newid, cdata$gid, cdata$dadid, cdata$momid, unique=0)
> dim(kin2)
[1] 26050 26050
> dim(kin1)
[1] 26050 26050

> length(kin2@blocks)/length(kin1@blocks)
[1] 0.542462
# Basing kin1 on newid rather than cdata$famid (where marry-ins were each
#   labeled as members of one of the 426 families) reduced its size by just
#   less than half.
}
}
\keyword{manip}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{makekinship}
\alias{makekinship}
\title{
  Create a sparse kinship matrix
}
\description{
Compute the overall kinship matrix for a collection of families, and
store it efficiently.
}
\usage{
makekinship(famid, id, father.id, mother.id, unrelated=0)
}
\arguments{
\item{famid}{
a vector of family identifiers
}
\item{id}{
a vector of unique subject identifiers
}
\item{father.id }{
for each subject, the identifier of their biolgical father
}
\item{mother.id }{
for each subject, the identifier of thier biological mother
}
\item{unrelated}{
subjects with this family id are considered to be unrelated singletons,
i.e., not related to each other or to anyone else.
}
}
\value{
a sparse kinship matrix of class \code{bdsmatrix}
}
\details{
For each family of more than one member, the 
\code{kinship} function is called to calculate a
per-family kinship matrix.
These are stored in an efficient way into a single block-diagaonal sparse
matrix object, taking advantage of the fact that between family entries
in the full matrix are all 0.
Unrelated individuals are considered to be families of size 0, and are
placed first in the matrix.

The final order of the rows within this matrix will not necessarily be
the same as in the origianl data, since each family must be contiguous.
The dimnames of the matrix contain the id variable for each row/column.
Also note that to create the kinship matrix for a subset of the data
it is necessary to create the full kinship
matrix first and then subset it.  
One cannot first subset the data and then call the function.
For instance, a call using only the female data would not detect that a
particular man's sister and his daughter are related.
}
\seealso{
kinship, makefamid
}
\examples{
\dontrun{
# Data set from a large family study of breast cancer
#  there are 26050 subjects in the file, from 426 families
> table(cdata$sex)
     F     M 
 12699 13351
> length(unique(cdata$famid))
[1] 426

> kin1 <- makekinship(cdata$famid, cdata$gid, cdata$dadid, cdata$momid)
> dim(kin1)
[1] 26050 26050
> class(kin1)
[1] "bdsmatrix"
# The next line shows that few of the elements of the full matrix are >0
> length(kin1@blocks)/ prod(dim(kin1))
[1] 0.00164925

# kinship matrix for the females only
> femid <- cdata$gid[cdata$sex=='F']
> femindex <- !is.na(match(dimnames(kin1)[[1]], femid))
> kin2 <- kin1[femindex, femindex]
#
# Note that "femindex <- match(femid, dimnames(kin1)[[1]])" is wrong, since
#  then kin1[femindex, femindex] might improperly reorder the rows/cols 
#  (if families were not contiguous in cdata).  
# However sort(match(femid, dimnames(kin1)[[1]])) would be okay.
}
}
\keyword{manip}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{pedigree}
\alias{pedigree}
\title{
  Create pedigree structure 
}
\description{
Create pedigree structure in format needed for plotting function.
}
\usage{
pedigree(id, dadid, momid, sex, affected, status, relations)
}
\arguments{
\item{id}{
Identification variable for individual
}
\item{dadid}{
Identification variable for father
}
\item{momid}{
Identification variable for mother
}
\item{sex}{
Gender of individual noted in
`id'. Character("male","female","unknown",
"terminated")
or numeric (1="male", 2="female", 3="unknown", 4="terminated") allowed.
}
\item{affected}{
One variable, or a matrix, indicating affection status.  Assumed that
1="unaffected", 2="affected", NA or 0 = "unknown". 
}
\item{status}{
Status (0="censored", 1="dead")
}
\item{relations}{
A matrix with 3 columns (id1, id2, code) specifying special relationship
between pairs of individuals. Codes: 1=Monozygotic
twin,  2=Dizygotic twin, 3=Twin of unknown zygosity, 4=Spouse and no children in pedigree  
}
}
\value{
An object of class pedigree.
}
\seealso{
\code{\link{plot.pedigree}}
}
\examples{
\dontrun{
ptemp <- pedigree(id=d10$upn, dadid=d10$dadid,momid=d10$momid, 
                  sex=d10$sex, affected=d10$affect)
plot(ptemp)
}
}
\keyword{dplot}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{plot.pedigree}
\alias{plot.pedigree}
\title{
  plot pedigrees
}
\description{
plot objects created with the function pedigree
}
\usage{
plot.pedigree(x, id=x$id, sex=x$sex, status=x$status,
affected=x$affected, cex=1, col=rep(1, length(x$id)),
symbolsize=1, branch=0.6, packed=T, align=packed, width=8, density=c(-1,
50, 70, 90), mar=c(4.1,1,4.1,1), angle=c(90, 70, 50, 0), keep.par=F, ...)
}
\arguments{
\item{x}{
object created by the function pedigree.
}
\item{id}{
id variable - used for labelling.  
}
\item{sex}{
sex variable - used to determine which symbols are plotted. 
}
\item{status}{
can be missing.  If it exists, 0=alive/missing and 1=death.
}
\item{affected}{
variable, or matrix, of up to 4 columns representing 4 different
affected statuses.
}
\item{cex}{
controls text size.  Default=1.
}
\item{col}{
color for each id.  Default assigns the same color to everyone.
}
\item{symbolsize}{
controls symbolsize. Default=1.
}
\item{branch}{
defines how much angle is used to connect various levels of nuclear families.
}
\item{packed}{
default=T.  If T, uniform distance between all individuals at a given level.
}
\item{align}{
default=T.  Indicates extra effort should be spent trying to align parents
and children.  Set to F to speed up plotting.
}
\item{width}{
default=8.  For a packed pedigree, the minimum width allowed in the
realignment of pedigrees.
}
\item{density}{
defines density used in the symbols.  Takes up to 4 different values.
}
\item{mar}{
no comment(s)
}
\item{angle}{
defines angle used in the symbols.  Takes up to 4 different values.
}
\item{keep.par }{
Default = F, allows user to keep the parameter settings the same as they
were for plotting (useful for adding extras to the plot)
}
\item{\dots }{
Extra options that feed into the plot function.
}
}
\value{
returns points for each plot plus original pedigree.
}
\section{Side Effects}{
creates plot on current plotting device.
}
\seealso{
\code{\link{pedigree}}
}
\examples{
\dontrun{
ptemp <- pedigree(id=d10$upn, dadid=d10$dadid, momid=d10$momid, 
                  sex=d10$sex, affected=d10$affect)

plot(ptemp)

col.founder <- rep(1,length(d10$affect))
col.founder[d10$id==1] <- 2

plot(ptemp, affected=cbind(d10$affect,d10$affect2,d10$affect3,d10$affect4),
     col=col.founder, id=paste(ptemp$id,'\n','(',d10$post,')',sep=''),
     angle=c(90,80,70,60), density=c(-1,90,70,50))
}
}
\keyword{hplot}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{solve.bdsmatrix}
\alias{solve.bdsmatrix}
\title{
  Solve a matrix equation using the generalized Cholesky decompostion
}
\description{
This function solves the equation Ax=b for x, when
A is a block diagonal sparse matrix 
(an object of class \code{bdsmatrix}).
}
\usage{
solve.bdsmatrix(a, b, tolerance=1e-10, full=T, \ldots)
}
\arguments{
\item{a}{
a block diagonal sparse matrix object
}
\item{b}{
a numeric vector or matrix, that forms the right-hand side of the equation.
}
\item{tolerance}{
the tolerance for detecting singularity in the a matrix
}
\item{full}{
if true, return the full inverse matrix; if false return only
that portion corresponding to the blocks.  
This argument is ignored if \code{b} is present.
If the bdsmatrix \code{a} has a non-sparse portion,
i.e., if the  \code{rmat} component is present,
then the inverse of \code{a} will not be 
block-diagonal sparse.  
In this case setting full=F returns only a portion of the inverse.
The elements that are returned are those of the full inverse, but the
off-diagonal elements that are not returned would not have been zero.
}
\item{\ldots}{
an argument to achieve compatibility with solve from R base
}
}
\value{
if argument \code{b} is not present, the inverse of
\code{a} is returned, otherwise the solution to 
matrix equation.
The equation is solved using a generalized Cholesky decomposition.
}
\details{
The matrix \code{a} consists of a block diagonal
sparse portion with an optional dense border.
The inverse of \code{a}, which is to be computed if
\code{y} is not provided, will have the same
block diagonal structure as \code{a} only if there
is no dense border, otherwise the resulting matrix will not be sparse.

However, these matrices may often be very large, and a non sparse
version of one of them will require gigabytes of even terabytes of
space.  For one of the
common computations (degrees of freedom in a penalized model) only those
elements of the inverse that correspond to the non-zero part of
\code{a} are required;
the \code{full=F} option returns only that portion
of the (block diagonal portion of) the inverse matrix.
}
\seealso{
\code{\link{bdsmatrix}, \link{gchol}}
}
\examples{
\dontrun{
tmat <- bdsmatrix(c(3,2,2,4), 
              c(22,1,2,21,3,20,19,4,18,17,5,16,15,6,7, 8,14,9,10,13,11,12),
              matrix(c(1,0,1,1,0,0,1,1,0,1,0,10,0,
                       0,1,1,0,1,1,0,1,1,0,1,0,10), ncol=2))
dim(tmat)
solve(tmat, cbind(1:13, rep(1,13)))
}
}
\keyword{algebra}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{solve.gchol}
\alias{solve.gchol}
\title{
  Solve a matrix equation using the generalized Cholesky decompostion
}
\description{
This function solves the equation Ax=b for x, given b and the
generalized Cholesky decompostion of A.
If only the first argument is given, then a G-inverse of A is
returned.
}
\usage{
solve.gchol(a, b, full=T, \ldots)
}
\arguments{
\item{a}{
a generalized cholesky decompostion of a matrix, as
returned by the \code{gchol} function.
}
\item{b}{
a numeric vector or matrix, that forms the right-hand side of the equation.
}
\item{full}{
solve the problem for the full (orignal) matrix, or for the cholesky
matrix.
}
\item{\ldots}{
an argument to achieve compatibility with solve from R base
}
}
\value{
if argument \code{b} is not present, the inverse of
\code{a} is returned, otherwise the solution to 
matrix equation.
}
\details{
A symmetric matrix A can be decomposed as LDL', where L is a lower
triangular matrix with 1's on the diagonal, L' is the transpose of
L, and D is diagonal.  
This routine solves either the original problem Ay=b 
(\code{full} argument) or the subproblem sqrt(D)L'y=b.
If \code{b} is missing it returns the inverse of
A or L, respectively.
}
\seealso{
\code{\link{gchol}}
}
\examples{
\dontrun{
# Create a matrix that is symmetric, but not positive definite
#   The matrix temp has column 6 redundant with cols 1-5
smat <- matrix(1:64, ncol=8)
smat <- smat + t(smat) + diag(rep(20,8))  #smat is 8 by 8 symmetric
temp <-  smat[c(1:5, 5:8), c(1:5, 5:8)]
ch1  <- gchol(temp)

print(as.matrix(ch1))   # print out L
print(diag(ch1))        # print out D
aeq <- function(x,y) all.equal(as.vector(x), as.vector(y))
aeq(diag(ch1)[6], 0)    # Check that it has a zero in the proper place

ginv <- solve(ch1)    # see if I get a generalized inverse
aeq(temp \%*\% ginv \%*\% temp, temp)
aeq(ginv \%*\% temp \%*\% ginv, ginv)
}
}
\keyword{algebra}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{solve.gchol.bdsmatrix}
\alias{solve.gchol.bdsmatrix}
\title{ function solve for gchol.bdsmatrix }
\description{
  This is a generalized solve function for gchol.bdsmatrix object
}
\usage{
solve.gchol.bdsmatrix(a, b, full=T, \ldots)
}
\arguments{
  \item{a}{ \code{a} }
  \item{b}{ \code{b} }
  \item{full}{ An argument \code{full}}
  \item{\ldots}{an argument to achieve compatibility with solve from R base}
}

\keyword{algebra}

\eof
