### Name: makefamid
### Title: Identify family groups
### Aliases: makefamid
### Keywords: manip

### ** Examples

## Not run: 
##D > newid <- makefamid(cdata$gid, cdata$dadid, cdata$momid)
##D > table(newid==0)
##D  FALSE TRUE 
##D  17859 8191
##D # So nearly 1/3 of the individuals are not blood relatives.
##D 
##D > kin1 <- makekinship(cdata$famid, cdata$gid, cdata$dadid, cdata$momid)
##D > kin2 <- makekinship(newid, cdata$gid, cdata$dadid, cdata$momid, unique=0)
##D > dim(kin2)
##D [1] 26050 26050
##D > dim(kin1)
##D [1] 26050 26050
##D 
##D > length(kin2@blocks)/length(kin1@blocks)
##D [1] 0.542462
##D # Basing kin1 on newid rather than cdata$famid (where marry-ins were each
##D #   labeled as members of one of the 426 families) reduced its size by just
##D #   less than half.
## End(Not run)



