\name{as.lgtdl}
\alias{as.lgtdl}
\alias{is.lgtdl}
\title{Longitudinal Class}
\description{
  \code{as.lgtdl} coerces its argument to class \code{lgtdl} if possible.
  \code{is.lgtdl} returns \code{TRUE} if its argument is of class
  \code{lgtdl} and \code{FALSE} otherwise.
}
\usage{
as.lgtdl(x, row.names=NULL)
is.lgtdl(x)
}
\alias{is.lgtdl}

\arguments{
  \item{x}{An object which is coerced to a \code{lgtdl} object for
    \code{as.lgtdl} or tested with \code{is.lgtdl}.}
  \item{row.names}{An optional set of row names to be used for the names
    of the covariates in the resulting \code{lgtdl} object.}
}
\value{
  \item{is.lgtdl} {Returns \code{TRUE} if its argument is of class
    \code{lgtdl}.}
  \item{as.lgtdl} {Returns an object of class \code{lgtdl}.}
}
\author{Robert Gentleman}

\seealso{ \code{\link{plot.lgtdl}}, \code{\link{lgtdl}} }

\examples{
  x1<-data.frame(time=c(1,3,5), cov=c(4,6,8))
  x2<-data.frame(time=c(11,13,15), interest=c(66,45,88))

  x1<-as.lgtdl(x1)
  x2<-as.lgtdl(x2)

  is.lgtdl(TRUE)
}
\keyword{manip}

\eof
\name{getcov}
\alias{getcov}
\alias{getcov.lgtdl}
\title{ A function to extract the covariate from an object of class
  lgtdl. }
\description{
  The covariate component of the \code{lgtdl} object is returned.
}
\usage{
getcov(x, ...)
getcov.lgtdl(x, cov, ...)
}

\arguments{
  \item{x}{ The \code{lgtdl} object. }
  \item{cov}{The name of the covariate to be extracted.  } 
  \item{\dots}{Ignored, there for potential future use. }

}

\value{
The covariate, as either a matrix or vector, is returned.
}

\author{ Robert Gentleman }

\seealso{  \code{\link{lgtdl}}, \code{\link{as.lgtdl}} }

\examples{
  x1<-data.frame(time=c(1,3,5), cov=c(4,6,8))
  x2<-data.frame(time=c(11,13,15), interest=c(66,45,88))

  x1<-as.lgtdl(x1)
  x2<-as.lgtdl(x2)
  getcov(x1)
  getcov(x2)
}
\keyword{utilities}

\eof
\name{interplinear}
\alias{interplinear}
\alias{interplinear.lgtdl}
\alias{interplinear.AsIs}
\title{ A function to provide estimates of the response for a
  longitudinal data object. The estimate is obtained by linear
  interpolation from the preceding and following observations. }
\description{
  A linear interpolation, using \code{\link{approx}}, is used to obtain
  estimates of the covariate at times other than those observed.
}
\usage{
interplinear(x, ...)
interplinear.lgtdl(x, time, cov = NULL, ...)
interplinear.AsIs(x, ...)
}

\arguments{
  \item{x}{ The \code{lgtdl} object that is to be interpolated. }
  \item{time} {The time(s) at which interpolation is desired.}
  \item{cov}{The name of the covariate in the \code{lgtdl} object on
    which the interpolation should be based. It is not required if there
    is only one covariate.}
  \item{\dots}{ Ignored. }
}
\value{
  A vector containing the interpolated estimates of the covariate values
  at the requested times.
}
\author{ Robert Gentleman }
\seealso{ \code{\link{interpprev}} }

\examples{
  x1<-data.frame(time=c(1,3,5), cov=c(4,6,8))
  x2<-data.frame(time=c(11,13,15), interest=c(66,45,88))
  x1<-as.lgtdl(x1)
  x2<-as.lgtdl(x2)
  interpprev(x1, 4)
  interpprev(x2, c(12, 14))
}
\keyword{smooth}

\eof
\name{interpprev}
\alias{interpprev}
\alias{interpprev.lgtdl}
\alias{interpprev.AsIs}
\title{ Interpolation Using the Previous Value }
\description{
  These functions provide an interpolation mechanism for objects of
  class \code{lgtdl}. The \code{AsIs} method is the vectorized version.
}
\usage{
interpprev(x, ...)
interpprev.lgtdl(x, time, cov, ...)
interpprev.AsIs(x, ...)
}

\arguments{
  \item{x}{ \code{x} is either an object of class \code{lgtdl} or of
    class \code{AsIs}. It is the object on which interpolation is to be
    performed.  }
  \item{time}{A vector of times at which interpolation is requested.}
  \item{cov}{The name of the covariate on which interpolation is
    requested. It is only required if \code{x} has more than one
    covariate.}
  \item{\dots}{ Ignored. }
}
\details{
 If objects of class \code{lgtdl} are inserted into a data frame they
 become a vector with class \code{AsIs}. In order to operate on these
 we provide a method for that class. The method is simply a vectorized
 version.
}
\value{
  \code{interpprev.lgtdl} returns a numeric vector of the interpolated
  values of the covariate at the time(s) specified by \code{time}.
  \code{interpprev.AsIs} returns a vector of interpolated values of the
  covariate. In this case the vector contains one value for each element
  \code{x}. \code{time} must be either the same length as \code{x} or
  of length one. In the latter case all interpolations are done at that
  time. 
}
\author{Robert Gentleman }
\seealso{ \code{\link{interplinear}} }

\examples{
  x1<-data.frame(time=c(1,3,5), cov=c(4,6,8))
  x2<-data.frame(time=c(11,13,15), interest=c(66,45,88))
  x1<-as.lgtdl(x1)
  x2<-as.lgtdl(x2)
  interpprev(x1, c(2,4))
  interpprev(x2, c(12, 14))
}
\keyword{smooth}

\eof
\name{toString.lgtdl}
\alias{toString.lgtdl}

\title{ Produce a character string suitable for printing. }
\description{
 Data frames can contain \code{lgtdl} objects as elements. When the data
 frame is printed this function provides a suitable string for printing.
}
\usage{
toString.lgtdl(x, width, ...)
}

\arguments{
  \item{x}{ The object to be formated. }
  \item{width}{ To control the width of the returned string-ignored. }
  \item{\dots}{ Ignored. }
}

\value{
  A character string. Currently it is \code{"lgtdl, length = "} with the
  length of the \code{time} component added.
}
\author{ Robert Gentleman }
\seealso{ \code{toString} }

\keyword{utilities }

\eof
\name{lgtdl-internal}
\alias{covnames}
\alias{print.lgtdl}

\title{Internal Icens functions}
\description{
 Internal Icens functions
}
\usage{
While user level they don't really warrant any form of documentation.
}
\details{
  These are not documented.
}
\keyword{ts}

\eof
\name{lgtdl}
\alias{lgtdl}
\title{Longitudinal Class }
\description{
  The \code{lgtdl} class is a simple class of R/S objects that make it
  simpler to manipulate longitudinal data.
}

\author{Robert Gentleman}

\keyword{methods}


\eof
\name{plot.lgtdl}
\alias{plot.lgtdl}
\title{ A function for plotting lgtdl objects. }
\description{
 A lgtdly object consists of a time component and one or more covariates
 measured or observed at the times specified in the time component. This
 function plots the covariate trajectories as lines on the y axis.
}
\usage{
plot.lgtdl(x, ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{ An object of class \code{\link{lgtdl}}. }
  \item{\dots}{ Optional arguments to control the plotting. }
}
\details{
  One should be able to specify values for any of the graphics
  parameters to change the appearance of the plot.
}
\value{
  No value is returned. A line plot of the longitudinal object is
  rendered on the active graphics device.
}
\author{ Robert Gentleman }

\seealso{  \code{\link{lgtdl}}}

\examples{
  x1<-data.frame(time=c(1,3,5), cov=c(4,6,8))
  x2<-data.frame(time=c(11,13,15), interest=c(66,45,88))

  x1<-as.lgtdl(x1)
  x2<-as.lgtdl(x2)
  plot(x1)
  plot(x2)

}
\keyword{hplot}

\eof
