\name{anolis.ssd}
\alias{anolis.ssd}
\docType{data}
\title{Greater Antillean anolis lizard sexual size dimorphism data.}
\description{
  The dataset consists of sexual size-dimorphism data for 38 species of
  anoles from Cuba, Hispaniola, Jamaica, and Puerto Rico (Butler,
  Schoener, and Losos 2000). Each of these species belongs to one of six
  microhabitat types, or ``ecomorphs'' (sensu Williams, 1972): trunk-ground,
  grass-bush, trunk, trunk-crown, twig, and crown-giant. The data were
  used to demonstrate an evolutionary association between habitat type and
  degree of sexual size dimorphism.
}
\usage{data(anolis.ssd)}
\format{
  A data frame with 38 observations on the following 6 variables.
  \describe{
    \item{species}{Names of extant species.}
    \item{log.SSD}{Log sexual size dimorphism of extant species.}
    \item{ancestor}{Ancestor node.}
    \item{time}{Time of node.}
    \item{OU.1}{a factor with levels \code{ns}}
    \item{OU.7}{a factor with levels corresponding to ecomorph
      (\code{tg} \code{tc} \code{gb} \code{cg} \code{tw} \code{tr}
      \code{anc})}
  }
}
\details{
  Size dimorphism was calcuated as the log-ratio of male snout-to-vent
  length to female snout-to-vent length. (males are larger).

  In this example, we tested three models of evolution: Brownian
  motion, Ornstein-Uhlenbeck with one global optimum, and
  Ornstein-Uhlenbeck with 7 optima (one for each ecomorph type plus an
  additional one for an ``unknown'' type).

  For the 7-optima model, we assigned each terminal branch to an
  optimum according to the ecomorph type of the extant
  species. Because we had no information to help guide hypotheses
  about internal branches, we assigned internal branches to the
  ``unknown'' selective regime. The phylogeny of these species is
  consistent with and adaptive radiation, with a burst of speciation
  events early in the evolutionary history of this clade (see
  phylogeny in Butler & King (2004) or execute the following commands:

  \code{data(anolis.ssd)}\cr
  \code{attach(anolis.ssd)}\cr
  \code{tree.plot(ancestor, time, species, OU.7)}

}
\source{
  Butler, M.A. and A.A. King (2004) Phylogenetic comparative analysis: a
  modeling approach for adaptive evolution. American Naturalist, in press.
}
\references{
  Butler, M. A., T. W. Schoener, and J. B. Losos. 2000. The
  relationship between sexual size dimorphism and habitat use in
  Greater Antillean Anolis lizards. Evolution, 54:259-272.

  Williams, E. E. 1972. The origin of faunas. Evolution of lizard
  congeners in a complex island fauna: a trial analysis. Evol. Biol.,
  6:47-89.
}
\examples{
data(anolis.ssd)
attach(anolis.ssd)
tree.plot(ancestor,time,species,OU.7)
brown.fit(log.SSD,ancestor,time)
hansen.fit(log.SSD,ancestor,time,OU.1)
hansen.fit(log.SSD,ancestor,time,OU.7)
}
\author{Aaron A. King <king at tiem dot utk dot edu>}
\keyword{models}


\eof
\name{bimac}
\alias{bimac}
\docType{data}
\title{Anolis bimaculatus lizard size data.}
\description{
  This is the Anolis bimaculatus dataset used in Butler & King
  2004. It is used to test a hypothesis of character displacement
  using an interspecific dataset of body sizes and current data on
  sympatry/allopatry.  The data frame consists of the following
  columns: \code{species} which are species names, \code{size} which
  is the phenotypic data, and the variables \code{ancestor} and
  \code{time} which specify the topology of the phylogeny and the
  location of the nodes in time, respectively. The columns
  \code{OU.1}, \code{OU.3}, \code{OU.4}, and \code{OU.LP} specify the
  hypothesized selective regimes (there are four alternatives in this
  example).  Explanations of the data are given below.  Mean species
  lengths.  }
\usage{data(bimac)}
\format{
  A data frame with 45 observations on the following 8 variables.
  \describe{
    \item{species}{Species names for extant species.}
    \item{size}{Body size (head length in mm) of extant species.}
    \item{ancestor}{Ancestral node.}
    \item{time}{Time of node.}
    \item{OU.1}{a factor with levels \code{ns}}
    \item{OU.3}{a factor with levels \code{small} \code{medium} \code{large}}
    \item{OU.4}{a factor with levels \code{small} \code{medium} \code{large} \code{anc}}
    \item{OU.LP}{a factor with levels \code{small} \code{medium} \code{large}}
  }
}
\details{
  \item{Body size.}{We use the phenotypic data and phylogeny of Losos
  (1990), which employed the head lengths (of males) as a proxy for
  body size. In this group of lizards, head length correlates very
  strongly with snout-to-vent length and the cube root of mass, which
  are standard measures of body size. The data are head lengths in mm,
  note that we use the log of this value in analyses.}  

  \item{Tree topology}{The tree topology is encoded via two vectors:
  \code{ancestor} and \code{time}.  Each node of the phylogenetic tree
  has a corresponding row in the data frame, numbered from 1 to 45.
  The columns \code{ancestor} and \code{time} specify the phylogeny.
  The \code{ancestor} variable specifies the topology: it is a list
  indicating the ancestor of each node.  The root node has ancestor 0.
  The variable \code{time} specifies the temporal location of each node,
  with the root node being at time 0.}

  \item{Specifications of selective regimes.}{(Columns \code{OU.1},
    \code{OU.3}, \code{OU.4}, \code{OU.LP}).  These columns are
    factors, the levels of which correspond to the ``paintings'' of
    the respective adaptive regime hypotheses onto the phylogeny. Each
    selective regime is named (small, medium, large, etc.).  Put the
    corresponding name on each branch segment to indicate which
    selective regime it belongs to. Each column corresponds to a
    different painting of the selective regimes, and thus to a
    different hypothesis.  In this example, there are 3 alternative
    models (see Butler & King 2004): \code{OU.4} is 4-regime model,
    \code{OU.3} is 3-regime model (all ancestors are medium),
    \code{OU.LP} is linear parsimony model.}  }
\source{
  Butler, M.A. and A.A. King (2004) Phylogenetic comparative analysis: a
  modeling approach for adaptive evolution. American Naturalist, in press.
}
\references{
  Lazell, J. D. 1972. The anoles (Sauria: Iguanidae) of the Lesser
  Antilles. Bull. Mus. Comp. Zool., 143:1-115.

  Losos, J. B. 1990. A phylogenetic analysis of character displacement in
  Caribbean Anolis lizards. Evolution, 44:558-569.
}
\examples{
data(bimac)
attach(bimac)
tree.plot(ancestor,time,names=species,regimes=OU.LP)
brown.fit(log(size),ancestor,time/max(time))
hansen.fit(log(size),ancestor,time/max(time),OU.1)
hansen.fit(log(size),ancestor,time/max(time),OU.3)
hansen.fit(log(size),ancestor,time/max(time),OU.4)
hansen.fit(log(size),ancestor,time/max(time),OU.LP)
}
\author{Aaron A. King <king at tiem dot utk dot edu>}
\keyword{models}

\eof
\name{brown.fit}
\alias{brown.fit}
\alias{brown.dev}
\title{Brownian-motion model of evolution along a phylogenetic tree}
\description{
  These functions relate to the Brownian motion model for phylogenetic
  evolution.
  \item{brown}{fits the parameters sigma and theta of this model to
    given data.}
  \item{brown.dev}{generates simulated data sets.}
}
\usage{
brown.fit(data, topology, times)
brown.dev(n = 1, topology, times, sigma, theta)
}
\arguments{
  \item{data}{Phenotypic data for extant species, i.e., at the
    terminal ends of the phylogenetic tree.}
  \item{topology}{Specification of the topology of the phylogenetic
    tree.  This is in the form of a vector of nonnegative integers, one
    for each node in the tree.  The i-th number is that of the ancestor
    of the i-th node.  The root node is distinguished by the number zero
    (0).}
  \item{times}{A vector of nonnegative numbers, one per node in the
    tree, specifying the time at which each node is located.  The root node
    should be assigned time 0.}
  \item{n}{the number of simulated data sets to generate.}
  \item{sigma}{the value of sigma to be used in the simulations.}
  \item{theta}{the value of theta to be used in the simulations.}
}
\value{
  brown returns a list of the following elements:
  \item{sigma}{Maximum likelihood estimate of sigma.}
  \item{theta}{Maximum likelihood estimate of theta.}
  \item{u}{-2 log likelihood.}
  \item{aic}{Akaike information criterion.}
  \item{sic}{Schwartz information criterion (=BIC)}
  \item{df}{Number of parameters estimated (= 2).}

  brown.dev returns a data frame containing simulated data sets.  Each
  realization is a row.
}
\references{
  Butler, M.A. and A.A. King (2004) Phylogenetic comparative analysis: a
  modeling approach for adaptive evolution. American Naturalist, in press.
}
\author{Aaron A. King <king at tiem dot utk dot edu>}
\keyword{models}

\eof
\name{hansen.fit}
\alias{hansen.fit}
\alias{hansen.dev}
\title{Hansen model of evolution along a phylogenetic tree}
\description{
  These functions relate to the Hansen model for phylogenetic evolution.
  \item{hansen.fit}{fits the parameters alpha, sigma, and theta of this
  model.}
  \item{hansen.dev}{generates random deviates from the Hansen model.}
}
\usage{
hansen.fit(data, topology, times, regimes,
           guess = 0, interval = c(0.001, 20), tol = 1e-12)
hansen.dev(n = 1, topology, times, regimes, alpha, sigma, theta)
}
\arguments{
  \item{data}{Phenotypic data for extant species, i.e., at the
  terminal ends of the phylogenetic tree.}
  \item{topology}{Specification of the topology of the phylogenetic
  tree.  This is in the form of a vector of nonnegative integers, one
  for each node in the tree.  The i-th number is that of the ancestor
  of the i-th node.  The root node is distinguished by the number zero
  (0).}
  \item{times}{A vector of nonnegative numbers, one per node in the
  tree, specifying the time at which each node is located.  The root node
  should be assigned time 0.}
  \item{regimes}{A vector of codes, one for each node in the
  tree, specifying the selective regimes hypothesized to have been
  operative.  Corresponding to each node, enter the code of the regime
  hypothesized for the branch segment terminating in that node.
  For the root node, because it has no branch segment terminating on
  it, the regime specification is irrelevant.}
  \item{guess}{(Optional).  An initial guess for the selection
  strength parameter alpha.  This is used to initialize the
  optimization algorithm.}
  \item{interval}{The interval which will be searched for the optimal
  alpha.  By default, 0.001 < alpha < 20.}
  \item{tol}{Convergence tolerance.}
  \item{n}{Number of pseudorandom data sets to generate.}
  \item{alpha}{Value of alpha to use.}
  \item{sigma}{Value of sigma to use.}
  \item{theta}{Value of theta to use.}
}
\value{
  hansen.fit returns a list containing the following elements:
  \item{alpha}{Maximum likelihood estimate of alpha.  Note that if
  alpha lies against one of the constraints (see \code{interval}
  above), then this is not a maximum-likelihood estimate.} 
  \item{sigma}{Maximum likelihood estimate of sigma.}
  \item{theta}{Maximum likelihood estimate of theta.}
  \item{u}{-2 log likelihood.}
  \item{aic}{Akaike information criterion.}
  \item{sic}{Schwartz information criterion (=BIC)}
  \item{df}{Number of parameters estimated (= 3 + number of regimes).}

  hansen.dev returns a data frame containing simulated data sets.  Each
  realization is a row.
}
\references{
  Butler, M.A. and A.A. King (2004) Phylogenetic comparative analysis: a
  modeling approach for adaptive evolution. American Naturalist, in press.
}
\author{Aaron A. King <king at tiem dot utk dot edu>}
\keyword{models}

\eof
\name{tree.plot}
\alias{tree.plot}
\title{Simple plot of phylogenetic tree.}
\description{
  Plot the tree.
}
\usage{
tree.plot(topology, times, names = NULL, regimes = NULL)
}
\arguments{
  \item{topology}{Specification of the topology of the phylogenetic
  tree.  This is in the form of a vector of nonnegative integers, one
  for each node in the tree.  The i-th number is that of the ancestor
  of the i-th node.  The root node is distinguished by the number zero
  (0).}
  \item{times}{A vector of nonnegative numbers, one per node in the
  tree, specifying the time at which each node is located.  The root node
  should be assigned time 0.}
  \item{names}{Optional vector of species names.}
  \item{regimes}{A vector of codes, one for each node in the
  tree, specifying the selective regimes hypothesized to have been
  operative.  Corresponding to each node, enter the code of the regime
  hypothesized for the branch segment terminating in that node.
  For the root node, because it has no branch segment terminating on
  it, the regime specification is irrelevant.}
}
\examples{
data(bimac)
attach(bimac)
tree.plot(ancestor,time,species,OU.LP)
}
\author{Aaron A. King <king at tiem dot utk dot edu>}
\keyword{hplot}

\eof
