\name{R.to.Tcl}
\alias{R.to.Tcl}
\title{Convert a Character Vector to Tcl Format }
\description{
Converts a character vector into a brace-delimited Tcl list
}
\usage{
R.to.Tcl(character.vector)
}
\arguments{
  \item{character.vector}{A character vector}
}
\value{
A character vector of length 1
}
\author{David Firth, \email{d.firth@warwick.ac.uk}}
\seealso{\code{\link{Tcl.to.R}}}

\examples{
R.to.Tcl(c("apple","banana"))
}
\keyword{utilities}


\eof
\name{Tcl.to.R}
\alias{Tcl.to.R}
\title{Convert a Tcl List to R Character Vector}
\description{
Converts a brace-delimited list from Tcl into a character vector
}
\usage{
Tcl.to.R(tcl.list)
}
\arguments{
  \item{tcl.list}{a character string}
}
\value{
a character vector
}
\author{David Firth, \email{d.firth@warwick.ac.uk}}
\seealso{\code{\link{R.to.Tcl}}}

\examples{
Tcl.to.R("{apple} {banana} {pear}")
}
\keyword{utilities}


\eof
\name{pickFrom}
\alias{pickFrom}
\title{Pick Subsets from a Vector}
\description{
  Provides a Tk dialog for interactive selection of one or more subsets
  from a vector.  Requires the \code{tcltk} package.
}
\usage{
pickFrom(vec, nsets = 1, return.indices = FALSE, setlabels = NULL,
  title = "Subset picker",
  items.label = "Pick from:")
}
\arguments{
  \item{vec}{a vector}
  \item{nsets}{an integer, the number of subsets to be selected}
  \item{return.indices}{logical, whether indices (\code{TRUE}) or vector
    contents (\code{FALSE}) are to be returned}
  \item{setlabels}{a character vector of labels for the subsets}
  \item{title}{title of the Tk dialog window}
  \item{items.label}{a label for the set of items to be selected from}
}
\value{
  A list, with \code{nsets} components.  Each component is a
  selected sub-vector, or a numeric vector of indices for a
  selected sub-vector (if \code{return.indices} is \code{TRUE});
  the component names are as specified in \code{setlabels}, or interactively.
}
\author{David Firth, \email{d.firth@warwick.ac.uk}}

\examples{
## This cannot be run by example() but should be OK when pasted
## into an interactive R session
\dontrun{
pickFrom(c("apple", "banana", "plum", "grapefruit"), nsets = 2,
  setlabels = c("Fruits I like", "Fruits I tolerate"))
}}
\keyword{utilities}


\eof
\name{relimp}
\alias{relimp}
\alias{print.relimp}

\title{Relative Importance of Predictors in a Regression Model}
\description{
     Produces a summary
     of the relative importance of two predictors or two sets of predictors
     in a fitted model object.
}
\usage{
relimp(object, set1=NULL,  set2=NULL, label1="set1", label2="set2", 
          subset=TRUE, 
          response.cat=NULL, ...)
print.relimp(x, digits=3, ...)
}

\arguments{
  \item{object}{A model object of class
    \code{\link{lm}}, \code{\link{glm}}, \code{\link[survival]{coxph}},
    \code{\link[survival]{survreg}}, 
    \code{\link[nnet]{multinom}}, 
    \code{\link[MASS]{polr}}, \code{\link[nlme]{gls}} or \code{\link[nlme]{lme}}}
  \item{set1}{An index or vector of indices for the effects to be
    included in the numerator of the comparison}
  \item{set2}{An index or vector of indices for the effects to be
    included in the denominator of the comparison}
  \item{label1}{A character string; mnemonic name for the 
    variables in \code{set1}}
  \item{label2}{A character string; mnemonic name for the
    variables in \code{set2}}
  \item{subset}{Either a vector of numeric indices for the cases to be included
    in the standardization of effects, or a vector of logicals
    (\code{TRUE} for inclusion)
    whose length is the same as the number of rows in the model frame,
    \code{object$model}.
    The default choice is to include all cases in the model frame.}
  \item{response.cat}{If \code{object} is of class \code{multinom}, 
    this is a character
    string used to specify which regression is of interest (i.e., the
    regression
    which predicts the log odds on \code{response cat} versus the model's 
    reference category).  The \code{response.cat} argument should be an
    element of
    \code{object$lab}; or \code{NULL} if \code{object} is not of class
    \code{multinom}.}
  \item{\dots}{For models of class \code{glm}, one may additionally set
    the dispersion parameter for the family (for example,
    \code{dispersion=1.69}). By default
    it is obtained from \code{object}.  Supplying it here
    permits explicit allowance for over-dispersion, for example.}
  \item{x}{an object of class \code{relimp}}
  \item{digits}{The number of decimal places to be used in the printed 
    summary.  Default is 3.}
}

\details{If \code{set1} and \code{set2} both have length 1, relative importance is
  measured by the ratio of the two standardized coefficients.
  Equivalently this is the ratio of the standard deviations of the two
  contributions to the linear predictor, and this provides the
  generalization to comparing two sets rather than just a pair of predictors.

  The computed ratio is the square root of the variance-ratio quantity
  denoted as `omega' in Silber, J H, Rosenbaum, P R and Ross, R N
  (1995).  Estimated standard errors are calculated by
  the delta method, as described in that paper for example. 
  
  If \code{set1} and \code{set2} are unspecified, and if the \code{tcltk} package has been 
  loaded, a dialog box is provided (by a call to \code{\link{pickFrom}})
  for the choice of \code{set1} and \code{set2} from the available model coefficients.
}

\value{
  An object of class \code{relimp}, with at least the following components:
  \item{model}{The call used to construct the model object summarized}
  \item{sets}{The two sets of indices specified as arguments}
  \item{log.ratio}{The natural logarithm of the ratio of effect
    standard deviations corresponding to the two sets specified}
  \item{se.log.ratio}{An estimated standard error for log.ratio}
  
  If \code{dispersion} was supplied as an argument, its value is stored as the
  \code{dispersion} component of the resultant object.
}
\references{Silber, J. H., Rosenbaum, P. R. and Ross, R N (1995)
  Comparing the Contributions of Groups of Predictors: Which Outcomes
  Vary with Hospital Rather than Patient Characteristics?  \emph{JASA} \bold{90},
  7--18.
  }
\author{David Firth \email{d.firth@warwick.ac.uk} }

\seealso{\code{\link{relrelimp}}}

\examples{
x <- rnorm(100)
z <- rnorm(100)
w <- rnorm(100)
y <- 3+ 2*x + z + w + rnorm(100)
test <- lm(y ~ x +z +w)
print(test)
relimp(test, 2, 3)    #  compares effects of x and z
relimp(test, 2, 3:4)  #  compares effect of x with that of (z,w) combined
##
##  Data on housing and satisfaction, from Venables and Ripley
##  -- multinomial logit model
library(MASS)
library(nnet)
data(housing)
house.mult <- multinom(Sat ~ Infl + Type + Cont, weights = Freq,
  data = housing)
relimp(house.mult, set1 = 2:3, set2 = 7, response.cat = "High")
}
\keyword{models}
\keyword{regression}

\eof
\name{relrelimp}
\alias{relrelimp}

\title{Comparison of Relative Importances in a 
     Multinomial Logit Model}
\description{
     Produces a summary
     of the relative importance of two predictors or two sets of predictors
     in a fitted \code{\link[nnet]{multinom}} model object, and compares 
     relative importances
     across two of the fitted logit models.
}
\usage{
relrelimp(object, set1=NULL, set2=NULL, label1="set1", label2="set2", 
          subset=TRUE, 
          response.cat1=NULL, response.cat2=NULL)
}

\arguments{
  \item{object}{A model object of class
    \code{multinom}}
  \item{set1}{An index or vector of indices for the effects to be
    included in the numerator of the comparison}
  \item{set2}{An index or vector of indices for the effects to be
    included in the denominator of the comparison}
  \item{label1}{A character string; mnemonic name for the 
    variables in \code{set1}}
  \item{label2}{A character string; mnemonic name for the
    variables in \code{set2}}
  \item{subset}{Either a vector of numeric indices for the cases to be included
    in the standardization of effects, or a vector of logicals
    (\code{TRUE} for inclusion)
    whose length is the same as the number of rows in the model frame,
    \code{object$model}.
    The default choice is to include all cases in the model frame.}
  \item{response.cat1}{A character
    string used to specify the first regression of interest
    (i.e., the regression
    which predicts the log odds on \code{response.cat1} versus the model's 
    reference category).  The \code{response.cat1} argument should be an
    element of \code{object$lab}.}
  \item{response.cat2}{A character
    string used to specify the second regression of interest
    (i.e., the regression
    which predicts the log odds on \code{response.cat2} versus the model's 
    reference category).  The \code{response.cat2} argument should be an
    element of \code{object$lab}.}
}

\details{Computes a relative importance summary as described in
  \code{\link{relimp}}, for each of the two regressions specified by 
  \code{response.cat1}
  and \code{response.cat2} (relative to the same
  reference category); and computes the 
  difference of those two relative importance summaries,
  along with an estimated
  standard error for that difference.
}

\value{
  An object of class \code{relrelimp}, with at least the following components:
  \item{model}{The call used to construct the model object summarized}
  \item{sets}{The two sets of indices specified as arguments}
  \item{response.category}{A character vector containing the specified
    \code{response.cat1} and \code{response.cat2}}
  \item{log.ratio}{The natural logarithm of the ratio of effect
    standard deviations corresponding to the two sets specified.
    A vector with 
    three components: the first is for \code{response.cat1}
    versus the reference
    category, the second for \code{response.cat2} versus the
    reference category,
    the third is the difference.}
  \item{se.log.ratio}{Estimated standard errors for the elements of 
    \code{log.ratio}}
}

\author{David Firth, \email{d.firth@warwick.ac.uk} }

\seealso{\code{\link{relimp}}}

\examples{
##  Data on housing and satisfaction, from Venables and Ripley
library(MASS)
library(nnet)
data(housing)
house.mult <- multinom(Sat ~ Infl + Type + Cont, weights = Freq,
  data = housing)
relrelimp(house.mult, set1 = 2:3, set2 = 7, 
                      label1 = "Influence", label2 = "Contact",
                      response.cat1 = "Medium", response.cat2 = "High")
## Computes the relative contribution of Influence and Contact in 
## each of the two logistic regressions (Med/Low and High/Low), and
## compares those two relative-contribution measures.
}
\keyword{models}
\keyword{regression}

\eof
\name{showData}
\alias{showData}
\title{Display a Data Frame in a Tk Text Widget}
\description{
  Prints the contents of a data frame to a Tk text window,
  for inspection.
}
\usage{
showData(dataframe, 
       colname.bgcolor = "royalblue", 
       rowname.bgcolor = "grey90", 
       body.bgcolor = "white", 
       colname.textcolor = "white", 
       rowname.textcolor = "darkred", 
       body.textcolor = "black", 
       font = "Courier 12", 
       maxheight = 30, 
       maxwidth = 80, 
       title = NULL,
       rowname.bar = "left",
       colname.bar = "top",
       rownumbers = FALSE, 
       placement = "-20-40")
}
\arguments{
  \item{dataframe}{A data frame}
  \item{colname.bgcolor}{A background colour for the 
               variable-names panel}
  \item{rowname.bgcolor}{A background colour for the row-names panel}
  \item{body.bgcolor}{A background colour for the data}
  \item{colname.textcolor}{A colour for the variable names}
  \item{rowname.textcolor}{A colour for the row names}
  \item{body.textcolor}{A colour for the data}
  \item{font}{The text font used -- should be a monospaced font}
  \item{maxheight}{The maximum number of rows to display}
  \item{maxwidth}{The maximum width of display, in characters}
  \item{title}{A title for the window.  Default is to use the name of
    the dataframe as given in the call to \code{showData()}}
  \item{rowname.bar}{position of sidebar for row names, \code{"left"}
    or \code{"right"}, or \code{c("left","right")}, or \code{NULL}}
  \item{colname.bar}{position of column names, \code{"top"} or
    \code{"bottom"}, or \code{c("top","bottom")}, or \code{NULL}}
  \item{rownumbers}{logical, whether row numbers should be displayed}
  \item{placement}{Position of the bottom right corner of the window}
}
\value{
  \code{invisible(NULL)}
}
\author{David Firth, \email{d.firth@warwick.ac.uk}}
\examples{
## This cannot be run by example() but should be OK when pasted
## into an interactive R session
\dontrun{
data(mtcars)
showData(mtcars)}
}
\keyword{utilities}

\eof
