### Name: gscor
### Title: Find the Structural Correlations Between Two or More Graphs
### Aliases: gscor
### Keywords: univar multivariate

### ** Examples

#Generate two random graphs
g.1<-rgraph(5)
g.2<-rgraph(5)

#Copy one of the graphs and permute it
perm<-sample(1:5)
g.3<-g.2[perm,perm]

#What are the structural correlations between the labeled graphs?
gscor(g.1,g.2,exchange.list=1:5)
gscor(g.1,g.3,exchange.list=1:5)
gscor(g.2,g.3,exchange.list=1:5)

#What are the structural correlations between the underlying 
#unlabeled graphs?
gscor(g.1,g.2)
gscor(g.1,g.3)
gscor(g.2,g.3)



