reliability.plot        package:verification        R Documentation

_R_e_l_i_a_b_i_l_i_t_y _P_l_o_t

_D_e_s_c_r_i_p_t_i_o_n:

     A reliability plot is a simple form of an attribute diagram that
     depicts the performance of a probabilistic forecast for a binary
     event.  In this diagram, the forecast probability is plotted
     against the observed relative frequency.  Ideally, this value
     should be near to each other and so points falling on the 1:1 line
     are desirable.  For added information, if one or two forecasts are
     being verified, sharpness diagrams are presented in the corners of
     the plot.  Ideally, these histograms should be relatively flat,
     indicating that each bin of probabilities is use an appropriate
     amount of times.

_U_s_a_g_e:

        ## Default S3 method:
        reliability.plot(x, obar.i, prob.y, titl = NULL, legend.names = NULL, ... )
     ## S3 method for class 'verify':
     reliability.plot(x, ...)

_A_r_g_u_m_e_n_t_s:

       x: Forecast probabilities.(y_i) or a ``prob.bin'' class object
          from 'verify'.

  obar.i: Observed relative frequency bar{o}_i.

  prob.y: Relative frequency of forecasts

    titl: Title

legend.names: Names of each model that will appear in the legend.  

     ...: Graphical parameters.

_D_e_t_a_i_l_s:

     This function works either by entering vectors or on a verify
     class object.

_N_o_t_e:

     If a single prob.bin class object is used, a reliability plot
     along with a sharpness diagram is displayed.  If two forecasts are
     provided in the form of a matrix of predictions, two sharpness
     diagrams are provided.  If more forecasts are provided, the
     sharpness diagrams are not displayed.

_A_u_t_h_o_r(_s):

     Matt Pocernich <pocernic@rap.ucar.edu>

_R_e_f_e_r_e_n_c_e_s:

     Wilks, D. S. (1995) _Statistical Methods in the Atmospheric
     Sciences _ Chapter 7, San Diego: Academic Press.

_E_x_a_m_p_l_e_s:

     ## Data from Wilks, table 7.3 page 246.
      y.i   <- c(0,0.05, seq(0.1, 1, 0.1))
      obar.i <- c(0.006, 0.019, 0.059, 0.15, 0.277, 0.377, 0.511, 0.587, 0.723, 0.779, 0.934, 0.933)
      prob.y<- c(0.4112, 0.0671, 0.1833, 0.0986, 0.0616, 0.0366, 0.0303,  0.0275, 0.245, 0.022, 0.017, 0.203) 
      obar<- 0.162

     reliability.plot(y.i, obar.i, prob.y, titl = "Test 1", legend.names =
     c("Model A") )

     ## Function will work with a ``prob.bin'' class object as well.
     ## Note this is a very bad forecast.
     obs<- round(runif(100))
     pred<- runif(100)

     A<- verify(obs, pred, frcst.type = "prob", obs.type = "binary")

     reliability.plot(A, titl = "Alternative plot")
      

