% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
% ** Copyright UCAR (c) 1992 - 2004 
% ** University Corporation for Atmospheric Research(UCAR) 
% ** National Center for Atmospheric Research(NCAR) 
% ** Research Applications Program(RAP) 
% ** P.O.Box 3000, Boulder, Colorado, 80307-3000, USA 
% ** 2004/9/1 14:13:29 
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
\name{analysis.dat}
\alias{analysis.dat}
\title{
Spatial Observation Dataset.
}
\description{
This spatial data set is used by the \code{\link{int.scale.verify}}
function.  This consists of the outcome of the weather forecast presented
in \code{\link{forecast.dat}}. This data was provided by Barabara Casati and is
from the Met Office.
}
\keyword{datasets}
% docclass is data
% Converted by Sd2Rd version 1.21.

\eof
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
% ** Copyright UCAR (c) 1992 - 2004 
% ** University Corporation for Atmospheric Research(UCAR) 
% ** National Center for Atmospheric Research(NCAR) 
% ** Research Applications Program(RAP) 
% ** P.O.Box 3000, Boulder, Colorado, 80307-3000, USA 
% ** 2004/1/7 11:31:8 
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
\name{attribute}
\alias{attribute}
\alias{attribute.default}
\alias{attribute.prob.bin}

       \title{Attribute plot}
       \description{An attribute plot  illustrates
       the reliability, resolution and uncertainty of a forecast with
       respect to the observation.
       The frequency of binned forecast probabilities are plotted
       against proportions of binned observations.  A perfect forecast would
       be indicated by a line plotted along the 1:1 line.  Uncertainty
       is described as the vertical distance between this point and the
       1:1 line.  The
       relative frequency for each forecast value is displayed in parenthesis. }
      \usage{
\method{attribute}{default}(x, obar.i,  prob.y, obar = NULL, titl =
NULL, \dots)
\method{attribute}{prob.bin}(x, \dots)
       }
\arguments{
	 \item{x}{A vector of forecast probabilities or a ``prob.bin''
	   class object produced by the \code{verify} function. }
	 \item{obar.i}{A vector of observed relative frequency of forecast bins.} 
         \item{prob.y}{Relative frequency of forecasts of forecast bins. }
         \item{obar}{Climatological or sample mean of observed
	   events.}
         \item{titl}{Plot title. }
	 \item{\dots}{Graphical parameters} 
       }
	 \examples{
## Data from Wilks, table 7.3 page 246.
 y.i   <- c(0,0.05, seq(0.1, 1, 0.1))
 obar.i <- c(0.006, 0.019, 0.059, 0.15, 0.277, 0.377, 0.511, 
             0.587, 0.723, 0.779, 0.934, 0.933)
 prob.y<- c(0.4112, 0.0671, 0.1833, 0.0986, 0.0616, 0.0366,
            0.0303,  0.0275, 0.245, 0.022, 0.017, 0.203) 
 obar<- 0.162
 
attribute(y.i, obar.i, prob.y, obar, titl = "Sample Attribute Plot")  

## Function will work with a ``prob.bin'' class objects as well.
## Note this is a random forecast.
obs<- round(runif(100))
pred<- runif(100)

A<- verify(obs, pred, frcst.type = "prob", obs.type = "binary")

attribute(A, titl = "Alternative plot", xlab = "Alternate x label" )

}

\references{
  Hsu, W. R., and A.H. Murphy, 1986: The attributes diagram: A
  geometrical framework for assessing the quality of probability
  forecasts.  \emph{Int. J. Forecasting} \bold{2}, 285-293.
  
  Wilks, D. S. (1995) \emph{Statistical Methods in the Atmospheric Sciences }
  Chapter 7, San Diego: Academic Press.
}
\author{Matt Pocernich <pocernic@rap.ucar.edu>}

\seealso{\code{\link{verify}} }

       \keyword{file}

\eof
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
% ** Copyright UCAR (c) 1992 - 2004 
% ** University Corporation for Atmospheric Research(UCAR) 
% ** National Center for Atmospheric Research(NCAR) 
% ** Research Applications Program(RAP) 
% ** P.O.Box 3000, Boulder, Colorado, 80307-3000, USA 
% ** 2004/1/7 11:31:8 
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
\name{brier}
       \alias{brier}
       \title{Brier Score}
       \description{Calculates verification statistics for
	 probabilistic forecasts of binary events.}
       \usage{
    brier(obs, pred, baseline, thresholds = seq(0,1,0.1), \dots )
       }
      \arguments{
	\item{obs}{Vector of binary observations }
	\item{pred}{Vector of probablistic predictions [0,1] }
	\item{baseline}{Vector of climatological (no - skill) forecasts. If
	  this is null, a sample climatology will be calculated.}
	\item{thresholds}{Values used to bin the forecasts.  By default the
	  bins are \{[0,0.1), [0.1, 0.2), ....\} .}
	\item{\dots}{Optional arguments}
       }
       \value{
	 \item{baseline.tf}{Logical indicator of whether climatology was
	   provided.}
	 \item{bs}{Brier score}
	 \item{bs.baseline}{Brier Score for climatology}
	 \item{ss}{Skill score}
	 \item{bs.reliability}{Reliability portion of Brier score.}
	 \item{bs.resolution}{Resolution component of Brier score.}
	 \item{bs.uncert}{Uncertainty component of Brier score.}
	 \item{y.i}{Forecast bins -- described as the center value of
	   the bins.}
	 \item{obar.i}{Observation bins -- described as the center value
	 of the bins.}
	 \item{prob.y}{Proportion of time using each forecast}
	 \item{obar}{Forecast based on climatology or average sample
	   observations.}
	 
       }
       \note{This function is used within \code{verify}.}
	 \examples{

#  probabilistic/ binary example

pred<- runif(100)
obs<- round(runif(100))

brier(obs, pred)

}


\references{
  Wilks, D. S. (1995) \emph{Statistical Methods in the Atmospheric Sciences }
  Chapter 7, San Diego: Academic Press.
}
\author{Matt Pocernich <pocernic@rap.ucar.edu>}

       \keyword{file}

\eof
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
% ** Copyright UCAR (c) 1992 - 2004 
% ** University Corporation for Atmospheric Research(UCAR) 
% ** National Center for Atmospheric Research(NCAR) 
% ** Research Applications Program(RAP) 
% ** P.O.Box 3000, Boulder, Colorado, 80307-3000, USA 
% ** 2004/1/7 11:30:39 
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
\name{conditional.quantile}
       \alias{conditional.quantile}
       \title{Conditional Quantile Plot}
       \description{This function creates a conditional quantile plot as shown in
	 Murphy, et al (1989) and Wilks (1995).}
       \usage{
    conditional.quantile(pred, obs, bins = NULL, thrs = c(10, 20), main,
... ) }
       \arguments{
\item{pred}{Forecasted value. \emph{([n,1] vector, n = \# of forecasts)}}
\item{obs}{Observed value.\emph{([n,1] vector, n = \# of observations)}}
\item{bins}{Bins for forecast and observed values.  A minimum number of
values are required to calculate meaningful statistics.  So for
variables that are continuous, such as temperature, it is frequently
convenient to bin these values. \emph{([m,1] vector, m = \# of bins)}}
\item{thrs}{The minimum number of values in a bin required to calculate
the 25th and 75th quantiles and the 10th and 90th percentiles
respectively.  The median values will always be displayed. \emph{( [2,1]
  vector)} }
\item{main}{Plot title}
\item{\dots}{ Plotting options. }
}
        \value{This function produces a conditional.quantile plot.
The $y$ axis represents the observed values, while the $x$ axis
represents the forecasted values.  The histogram along the bottom axis
illustrates the frequency of each forecast.}
\note{In the example below, the median line extends beyond the range of
  the quartile or 10th and 90th percentile lines.  This is because there
  are not enough points in each bin to calculate these quartile values.
  That is, there are fewer than the limits set in the \code{thrs} input.}
\examples{

set.seed(10)
m<- seq(10, 25, length = 1000)  
frcst <- round(rnorm(1000, mean = m, sd = 2) )
obs<- round(rnorm(1000, mean = m, sd = 2 ))
bins <- seq(0, 30,1)
thrs<- c( 10, 20) # number of obs needed for a statistic to be printed #1,4 quartile, 2,3 quartiles

conditional.quantile(frcst, obs, bins, thrs, main = "Sample Conditional Quantile Plot")
#### Or plots a ``cont.cont'' class object.

obs<- rnorm(100)
pred<- rnorm(100)
baseline <- rnorm(100, sd = 0.5) 

A<- verify(obs, pred, baseline = baseline,  frcst.type = "cont", obs.type = "cont")
 plot(A)
}

\references{
  Murphy, A. H., B.G. Brown and Y. Chen. (1989) ``Diagnostic
  Verification of Temperature Forecasts,'' \emph{Weather and
    Forecasting}; December, 1989.
}
\author{Matt Pocernich <pocernic@rap.ucar.edu>}

       \keyword{file}

\eof
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
% ** Copyright UCAR (c) 1992 - 2004 
% ** University Corporation for Atmospheric Research(UCAR) 
% ** National Center for Atmospheric Research(NCAR) 
% ** Research Applications Program(RAP) 
% ** P.O.Box 3000, Boulder, Colorado, 80307-3000, USA 
% ** 2004/1/7 11:31:8 
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
\name{crps}
       \alias{crps}
       \title{Continuous Ranked Probability Score}
       \description{Calculates the crps for a forecast made in terms of
	 a normal probability distribution and an observation expressed
	 in terms of a continuous variable.}
       \usage{
    crps(obs, pred, ...)
       }
      \arguments{
	\item{obs}{A vector of observations.}
	\item{pred}{A vector or matrix of the mean and standard
	  deviation of a normal distribution.  If the vector has a
	  length of 2, it is assumed that these values represent the
	  mean and standard deviation of the normal distribution that
	  will be used for all forecasts.}
	\item{\dots}{Optional arguments}
       }
       \value{
	 \item{crps}{Continous ranked probability scores}
	 \item{CRPS}{Mean of crps}
	 \item{ign}{Ignorance score}
	 \item{IGN}{Mean of the ignorance score}
       }
       \note{This function is used within \code{verify}.}
	 \examples{

#  probabilistic/ binary example


x <- runif(100) ## simulated observation.
crps(x, c(0,1))

## simulated forecast in which mean and sd differs for each forecast.
frcs<- data.frame( runif(100, -2, 2), runif(100, 1, 3 ) )
crps(x, frcs)

}


\references{Gneiting, T., Westveld, A., Raferty, A. and Goldman, T, 2004:
  \emph{Calibrated Probabilistic Forecasting Using Ensemble Model Output
    Statistics and Minimum CRPS Estimation.} Technical Report no. 449,
  Department of Statistics, University of Washington. [ Available online
  at http://www.stat.washington.edu/www/research/reports/ ]}
\author{Matt Pocernich <pocernic@rap.ucar.edu>}

       \keyword{file}

\eof
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
% ** Copyright UCAR (c) 1992 - 2004 
% ** University Corporation for Atmospheric Research(UCAR) 
% ** National Center for Atmospheric Research(NCAR) 
% ** Research Applications Program(RAP) 
% ** P.O.Box 3000, Boulder, Colorado, 80307-3000, USA 
% ** 2004/1/7 11:31:8 
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
\name{discrimination.plot}
\alias{discrimination.plot}
\title{Discrimination  plot}
       \description{This function creates a plot of overlayed
	 histograms.   In the context of verification, this is often
	 used to compare the distribution of event and no-event forecasts.}
       \usage{discrimination.plot(obs, pred, breaks = 11, main = "Comparison of Distributions", xlim = c(0,1), median = TRUE, \dots }
}

\arguments{
          \item{obs}{A binary observation (coded \{0, 1 \} ).}
	 \item{pred}{A vector of predictions.}
	 \item{breaks}{Number of breaks in the x-axis of the histogram.}
	 \item{main}{Title for plot.}
	 \item{xlim}{Range of histogram - x axis.}
	 \item{median}{If TRUE, the median values for the event and the
	   no-event will be vertically plotted.  This is intended as a
	   non-paramtric indicator of the forecast's ability to
	   discriminate.  If FALSE, these vertical lines
	   will be surpressed.}
	 \item{\dots}{Additional plotting options.}
       }

        \examples{
 #  A sample forecast.  

 a<- rnorm(100, mean = -1); b<- rnorm(100, mean = 1)

 A<- cbind(rep(0,100), pnorm(a)); B<- cbind(rep(1,100), pnorm(b)) 

 dat<- rbind(A,B); dat<- as.data.frame(dat)
 names(dat)<- c("obs", "pred")

 discrimination.plot(dat$obs, dat$pred)
 }

\author{Matt Pocernich <pocernic@rap.ucar.edu>}

       \keyword{file}

\eof
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
% ** Copyright UCAR (c) 1992 - 2004 
% ** University Corporation for Atmospheric Research(UCAR) 
% ** National Center for Atmospheric Research(NCAR) 
% ** Research Applications Program(RAP) 
% ** P.O.Box 3000, Boulder, Colorado, 80307-3000, USA 
% ** 2004/9/1 14:13:29 
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
\name{forecast.dat}
\alias{forecast.dat}
\title{
Forecast forecast dataset.
}
\description{
This spatial data set is an example used by the \code{\link{int.scale.verify}}
function.  It consists of the Nimrod forecasting system and was provided
by Barbara Casati.
}
\keyword{datasets}
% docclass is data
% Converted by Sd2Rd version 1.21.

\eof
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
% ** Copyright UCAR (c) 1992 - 2004 
% ** University Corporation for Atmospheric Research(UCAR) 
% ** National Center for Atmospheric Research(NCAR) 
% ** Research Applications Program(RAP) 
% ** P.O.Box 3000, Boulder, Colorado, 80307-3000, USA 
% ** 2004/1/7 11:31:8 
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
\name{int.scale.verify}
       \alias{int.scale.verify}
       \title{Intensity-Scale Verification Model }
       \description{For a spatial forecast, evaluates the forecast skill
	 as a function of precipitaion rate intesity and spatial scale of the error.}
       \usage{
    int.scale.verify(frcs, obs, thres = quantile(frcs, p = seq(0,0.9,0.1)),  ... )
       }
      \arguments{
	\item{frcs}{Forecast matrix.  Must be of $2^n$ dimensions.}
	\item{obs}{Observation matrix. Must be of $2^n$ dimensions.}
	\item{thres}{A vector of thresholds to be considered.  By
	  default, the percentiles 0, 90 are used. }
	\item{\dots}{Optional arguments may be passed to the image plot}
       }
       \value{
	 \item{SSul}{Skill score as matrix.  The rownames are the
	   thresholds, the colnames are $n$ where $2^n$ is the spatial
	   scale of the skill score decomposition.}
	 \item{MSE}{A matrix with the mean squared error of the
	   forecast}
	 \item{l.frcs}{Number of rows in forecast.  Used in plotting
	   routine.}
	 \item{thres}{Thresholds used in model}
             }  

\note{ This function creates an image plot of the intensity plot of the
  skill scores as a function of spatial scale and threshold.  The top
  row is equivalent to the bias of the forecast.}
\examples{

## simulated example
n<- 5
set.seed(10)
forecast1 <- matrix( log(rlnorm(n = (2^n *2^n) )) , nrow = 2^n)
obs1      <- matrix(log( rlnorm(n = (2^n *2^n) )) , nrow = 2^n)
int.scale.verify(forecast1, obs1, main = "Test Case")  

## real example.  Data source referenced below.


data(analysis.dat)
data(forecast.dat)

require(waveslim)
require(fields)


A<- int.scale.verify(forecast.dat, analysis.dat,
thres = c(0, 2^seq(-5,6)),  main = "NIMROD example" )

plot(A)

}

\seealso{\url{http://www.met.rdg.ac.uk/~swr00bc/} }
\references{
B.Casati, D.B. Stephenson, G. Ross. \emph{A new intensity-scale
  approach for the verification of spatial precipitation forecasts}.
Meteorological Application (RMS), in press. }

\author{Barabara Casati <b.casati@reading.ac.uk>}

       \keyword{file}

\eof
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
% ** Copyright UCAR (c) 1992 - 2004 
% ** University Corporation for Atmospheric Research(UCAR) 
% ** National Center for Atmospheric Research(NCAR) 
% ** Research Applications Program(RAP) 
% ** P.O.Box 3000, Boulder, Colorado, 80307-3000, USA 
% ** 2004/1/7 11:31:8 
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
\name{leps}
       \alias{leps}
       \alias{leps.default}
       \title{Linear Error in Probability Space (LEPS) }
       \description{Calculates the linear error in probability spaces.
	 This is the mean absolute difference between the forecast
	 cumulative distribution value (cdf) and the observation.  This
	 function creates the empirical cdf function for the observations
	 using the sample population.  Linear interpretation is used to
	 estimate the cdf values between observation values.  Therefore;
	 this may produce awkward results with small datasets.}
       \usage{
    \method{leps}{default}(x, pred, plot = TRUE, \dots )
                         }
\arguments{
         \item{x}{A vector of observations or a verification object with ``cont.cont'' properties.}
	 \item{pred}{A vector of predictions.}  
	 \item{plot}{Logical to generate a plot or not.}
	 \item{\dots}{Additional plotting options.}
       }
       \value{
	 If assigned to an object, the following values are reported.
	 \item{leps.0}{Negatively oriented score on the [0,1] scale, where 0
	   is a perfect score.}
	 \item{leps.1}{Positively oriented score proposed by Potts.}
	 }

       \references{
DeQue, Michel. (2003) ``Continuous Variables'' \bold{Chapter 5},
\emph{Forecast Verification: A Practitioner's Guide in Atmospheric
  Science.}

Potts, J. M., Folland, C.K., Jolliffe, I.T. and Secton, D. (1996)
``Revised `LEPS' scores fore assessing climate model simulations and
long-range forecasts.'' \emph{J. Climate}, \bold{9}, pp. 34-54.

%Palmer, T.N., Brankovic, C. and Richadson, D. S. (2000), ``A probability
%and decision-model analysis of PROVOST seasonal multi-model
	}
       
 	\examples{
 obs <- rnorm(100, mean = 1, sd = sqrt(50))
 pred<-  rnorm(100, mean = 10, sd = sqrt(500))

 leps(obs, pred) 

 }
\author{Matt Pocernich <pocernic@rap.ucar.edu>}

       \keyword{file}

\eof
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
% ** Copyright UCAR (c) 1992 - 2004 
% ** University Corporation for Atmospheric Research(UCAR) 
% ** National Center for Atmospheric Research(NCAR) 
% ** Research Applications Program(RAP) 
% ** P.O.Box 3000, Boulder, Colorado, 80307-3000, USA 
% ** 2004/9/1 14:13:29 
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
\name{measurement.error}
       \alias{measurement.error}
        \title{Skill score with measurement error.}
       \description{Skill score that incorporates measurement error.
	 This function allows the user to incorporate measurement error
	 in an observation in a skill score.}
       \usage{measurement.error( obs, frcs = NULL, theta = 0.5, t = 1, u
= 0, h = NULL, \dots)
       }
       \arguments{
	 \item{obs}{Information about a forecast and observation can be
	   done in one of two ways.  First,  the results of a
	   contingency table can be entered as a vector containing
	   c(n11, n10, n01, n00), where n11 are the number of correctly
	   predicted events and n01 is the number of incorrectly
	   predicted non-events.  Actual forecasts and observations can
	   be used.  In this case, obs is a vector of binary outcomes
	   [0,1].}
	 \item{frcs}{If obs is entered as a contingency table, this
	   agrument is null.  If obs is a vector of outcomes, this
	   column is a vector of probablistic forecasts.}
	 \item{theta}{Loss value (cost) of making a incorrect forecast
	   by a non-event. Defaults to 0.5.}
	 \item{t}{Probability of forecasting an event, when an event
	   occurs.  A perfect value is 1.}
	 \item{u}{Probability of forecasting that no event will occur,
	   when and event occurs.  A perfect value is 0.}
	 \item{h}{Threshold for converting a probablistic forecast into
	   a binary forecast.  By default, this value is NULL and the
	   theta is used as this threshold.}
	 \item{\dots}{Optional arguments.}
       }
       \value{
	 \item{G}{Likelihood ratio statistic}
	 \item{p}{p-value for the null hypothesis that the forecast
	   contains skill.}
	 \item{K}{Skill score.}
       }
       \examples{
DAT<- data.frame( obs = round(runif(50)), frcs = runif(50))

 measurement.error(DAT$obs, DAT$frcs)

### Finley Data

measurement.error(c(28, 23, 72, 2680)) ## assuming perfect observation,
                                       
	 }

	 
	 \references{
W.M. Briggs, 2004.  \emph{Incorporating Cost in the  Skill Score}
Technical Report, wm-briggs.com/public/skillocst.pdf. 

W.M. Briggs and D. Ruppert, 2004. \emph{ Assessing the skill
  of yes/no forecasts. Submitting to Biometrics}.

J.P. Finley, 1884. Tornado forecasts. {\emph Amer. Meteor. J.}
85-88. (Tornado data used in example.)
}


\author{Matt Pocernich <pocernic@rap.ucar.edu> (R - code)

  W.M Briggs <wib2004(at)med.cornell.edu> (Method questions) }

       \keyword{file}

\eof
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
% ** Copyright UCAR (c) 1992 - 2004 
% ** University Corporation for Atmospheric Research(UCAR) 
% ** National Center for Atmospheric Research(NCAR) 
% ** Research Applications Program(RAP) 
% ** P.O.Box 3000, Boulder, Colorado, 80307-3000, USA 
% ** 2004/9/1 14:13:29 
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
\name{observation.error}
       \alias{observation.error}
        \title{Observation Error}
       \description{Quantifies observation error through use of a ``Gold
       Standard'' of observations.}
     \usage{
observation.error(obs, gold.standard = NULL, \dots)
       }
       \arguments{
	 \item{obs}{Observation made by method to be quantified.   This
	   information can be entered two ways.  If obs is a vector of
	   length 4, it is assumed that is contains the values c(n11,
	   n10, n01, n00), where n11 are the number of correctly
	   predicted events and n01 is the number of incorrectly
	   predicted non-events.  }
	 \item{gold.standard}{The gold standard.  This is considered a
	   higher quality observation (coded \{0, 1 \} ).}
	 \item{\dots}{Optional arguments.}
       }
       \value{
          \item{t}{Probability of forecasting an event, when an event
	   occurs.  A perfect value is 1. }
	 \item{u}{Probability of forecasting that no event will occur,
	   when and event occurs.  A perfect value is 0. }
       }
       \note{ This function is used to calculate values for the
	 \code{\link{measurement.error}} function.}
       \examples{
obs <- round(runif(100))
gold <- round(runif(100) )
observation.error(obs, gold)

## Pirep gold standard

observation.error(c(43,10,17,4) )
}
 \seealso{\code{measurement.error}}
\author{Matt Pocernich <pocernic@rap.ucar.edu>}

       \keyword{file}

\eof
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
% ** Copyright UCAR (c) 1992 - 2004 
% ** University Corporation for Atmospheric Research(UCAR) 
% ** National Center for Atmospheric Research(NCAR) 
% ** Research Applications Program(RAP) 
% ** P.O.Box 3000, Boulder, Colorado, 80307-3000, USA 
% ** 2004/1/7 11:31:8 
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
\name{plot.int.scale}
       \alias{plot.int.scale}
       \title{Plot Intensity Scale Objects.}
       \description{Plots objects from the
	 \code{\link{int.scale.verify}}  using the \code{image} function
	 from the base package and \code{image.plot} from the fields package..}
       \usage{
    plot.int.scale(x, y = NULL, plot.mse = FALSE, main = NULL, \dots)
       }
      \arguments{
	\item{x}{A object from the \code{int.scale.verify} function that
	  has the class int.scale.}
	\item{y}{NULL}
	\item{plot.mse}{Should a plot be created of the mean squared
	  errors?  By default the skill scores are plotted.}
	\item{main}{Plot title}  
	\item{\dots}{Optional arguments}
      }
      
       \seealso{\code{\link{int.scale.verify}},
	 \code{\link[base]{image}}, 
	 \code{\link[fields]{image.plot} } } 
       \examples{
data(analysis.dat)
data(forecast.dat)

A<- int.scale.verify(forecast.dat, analysis.dat, thres = c(0, 2^seq(-5,6)))
plot(A)
plot(A, plot.mse = TRUE)
plot(A, main = "Test case")
}


\author{Matt Pocernich <pocernic@rap.ucar.edu>}

       \keyword{file}

\eof
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
% ** Copyright UCAR (c) 1992 - 2004 
% ** University Corporation for Atmospheric Research(UCAR) 
% ** National Center for Atmospheric Research(NCAR) 
% ** Research Applications Program(RAP) 
% ** P.O.Box 3000, Boulder, Colorado, 80307-3000, USA 
% ** 2004/9/1 14:13:29 
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
\name{prob.frcs.dat}
\alias{prob.frcs.dat}
\title{ Probablisitic  Forecast Dataset. }
\description{
This data set is used as an example of data used by the \code{roc.plot}
function.  The first column contains a probablisitic forecast for
aviation icing.  The second column contains a logical variable
indicating whether or not icing was observed.  
}
\references{
  \emph{PROBABILITY FORECASTS OF IN-FLIGHT ICING
  CONDITIONS} Barbara G. Brown, Ben C. Bernstein, Frank McDonough and
  Tiffany A. O. Bernstein, 8th Conference on Aviation, Range, and
  Aerospace Meteorology, Dallas TX, 10-15 January 1999.
  }

\keyword{datasets}
% docclass is data
% Converted by Sd2Rd version 1.21.

\eof
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
% ** Copyright UCAR (c) 1992 - 2004 
% ** University Corporation for Atmospheric Research(UCAR) 
% ** National Center for Atmospheric Research(NCAR) 
% ** Research Applications Program(RAP) 
% ** P.O.Box 3000, Boulder, Colorado, 80307-3000, USA 
% ** 2004/1/7 11:31:8 
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
    \name{reliability.plot}
    \alias{reliability.plot}
    \alias{reliability.plot.default}
    \alias{reliability.plot.verify}

       \title{Reliability Plot}
       \description{A reliability plot is a simple form of an attribute
	 diagram that depicts the performance of a probabilistic forecast
       for a binary event.  In this diagram, the forecast probability is
       plotted against the observed relative frequency.  Ideally, this
       value should be near to each other and so points falling on the
       1:1 line are desirable.  For added information, if one or two
       forecasts are being verified, sharpness diagrams are presented in
       the corners of the plot.  Ideally, these histograms should be
       relatively flat, indicating that each bin of probabilities is use
       an appropriate amount of times.  }
       \usage{
   \method{reliability.plot}{default}(x, obar.i, prob.y, titl = NULL, legend.names = NULL, \dots )
\method{reliability.plot}{verify}(x, \dots)
}
\arguments{
         \item{x}{Forecast probabilities.(\eqn{y_i}) or a ``prob.bin''
	   class object from \code{verify}.}
	 \item{obar.i}{Observed relative frequency \eqn{\bar{o}_i}.}
      	 \item{prob.y}{Relative frequency of forecasts}
	 \item{titl}{Title}
	 \item{legend.names}{Names of each model that will appear in the
	   legend.  }
	 \item{\dots}{Graphical parameters.}
	 }
 	 \details{This function works either by entering vectors or
	   on a verify class object.}
	 \note{If a single prob.bin class object is used, a reliability
	   plot along with a sharpness diagram is displayed.  If two
	   forecasts are provided in the form of a matrix of predictions,
	   two sharpness diagrams are provided.  If more forecasts are
	   provided, the sharpness diagrams are not displayed.}
	 \examples{
## Data from Wilks, table 7.3 page 246.
 y.i   <- c(0,0.05, seq(0.1, 1, 0.1))
 obar.i <- c(0.006, 0.019, 0.059, 0.15, 0.277, 0.377, 0.511, 0.587, 0.723, 0.779, 0.934, 0.933)
 prob.y<- c(0.4112, 0.0671, 0.1833, 0.0986, 0.0616, 0.0366, 0.0303,  0.0275, 0.245, 0.022, 0.017, 0.203) 
 obar<- 0.162

reliability.plot(y.i, obar.i, prob.y, titl = "Test 1", legend.names =
c("Model A") )


## Function will work with a ``prob.bin'' class object as well.
## Note this is a very bad forecast.
obs<- round(runif(100))
pred<- runif(100)

A<- verify(obs, pred, frcst.type = "prob", obs.type = "binary")

reliability.plot(A, titl = "Alternative plot")
 

}
\references{
  Wilks, D. S. (1995) \emph{Statistical Methods in the Atmospheric Sciences }
  Chapter 7, San Diego: Academic Press.
}
\author{Matt Pocernich <pocernic@rap.ucar.edu>}

       \keyword{file}

\eof
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
% ** Copyright UCAR (c) 1992 - 2004 
% ** University Corporation for Atmospheric Research(UCAR) 
% ** National Center for Atmospheric Research(NCAR) 
% ** Research Applications Program(RAP) 
% ** P.O.Box 3000, Boulder, Colorado, 80307-3000, USA 
% ** 2004/1/7 11:31:8 
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
\name{roc.area}
       \alias{roc.area}
        \title{Area under curve (AUC) calculation for Response Operating Characteristic curve.}
       \description{This function calculates the area underneath a ROC
	 curve following the process outlined in Mason and Graham (2002).  The
	 p-value produced is related to the Mann-Whitney U statistics.
	 The p-value is based on the normal approximation of this
	 criteria.  This is applicable for ``\emph{large}'' amounts of
	 data.  The article suggests that more than 40 cases with at
	 least 10 cases for each outcome.

The p-value addresses the null hypothesis $H_o:$ The area under the ROC
curve is 0.5 i.e. the forecast has no skill. 
       }
       \usage{    roc.area(obs, pred)
       }
       \arguments{
	 \item{obs}{A binary observation (coded \{0, 1 \} ).}
	 \item{pred}{A probability prediction on the interval [0,1].}
       }

       \value{
	 \item{A.tilda}{Area under ROC curve, adjusted for ties in
	   forecasts, if present}
	 \item{n.total}{Total number of records}
	 \item{n.events}{Number of events}
	 \item{n.noevents}{Number of non-events}
	 \item{U}{U statistic for Mann-Whitney Test}
	 \item{p}{Unadjusted p-value}
	 \item{p.adj}{p-value adjusted for ties}
	 }
 \note{This function is used internally in the \code{roc.plot} command
   to calculate areas.}
 \seealso{\code{\link{roc.plot}}, \code{\link{verify}} }
 \references{Mason, S.J. and N.E. Graham. (2002) ``Areas beneath the
   relative operating characteristics (ROC) and relative operating
   levels (ROL) curves: Statistical significance and interpretation, ''
   \emph{Q. J. R. Meteorol. Soc.} \textbf{30} (1982) 291-303.}
 
	   \examples{# Data used from Mason and Graham (2002).
a<- c(1981, 1982, 1983, 1984, 1985, 1986, 1987, 1988, 1989, 1990,
 1991, 1992, 1993, 1994, 1995)
b<- c(0,0,0,1,1,1,0,1,1,0,0,0,0,1,1)
c<- c(.8, .8, 0, 1,1,.6, .4, .8, 0, 0, .2, 0, 0, 1,1)
d<- c(.928,.576, .008, .944, .832, .816, .136, .584, .032, .016, .28, .024, 0, .984, .952)

A<- data.frame(a,b,c, d)
names(A)<- c("year", "event", "p1", "p2")

## for model with ties
roc.area(A$event, A$p1)

## for model without ties
roc.area(A$event, A$p2)


}
\author{Matt Pocernich <pocernic@rap.ucar.edu>}

       \keyword{file}

\eof
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
% ** Copyright UCAR (c) 1992 - 2004 
% ** University Corporation for Atmospheric Research(UCAR) 
% ** National Center for Atmospheric Research(NCAR) 
% ** Research Applications Program(RAP) 
% ** P.O.Box 3000, Boulder, Colorado, 80307-3000, USA 
% ** 2004/1/7 11:31:8 
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
\name{roc.plot}
       \alias{roc.plot}
       \alias{roc.plot.default}
       \alias{roc.plot.prob.bin}
       \title{Relative operating characteristic curve.}
       \description{This function creates Receiver Operating
	 Characteristic (ROC) plots for one or more models.  A ROC curve
       plots the false alarm rate against the hit rate for a
       probablistic forecast for a range of thresholds. The area under
       the curve is viewed as a measure of a forecast's accuracy.  A
       measure of 1 would indicate a perfect model.  A measure of 0.5
       would indicate a random forecast. }
       \usage{
    \method{roc.plot}{default}(x, pred, thresholds = NULL, binormal =
FALSE,   leg = NULL, plot = "emp", plot.thres = seq(0.1,
0.9, 0.1), main = "ROC Curve", xlab = "False Alarm Rate", ylab = "Hit Rate", \dots)
\method{roc.plot}{prob.bin}(x, \dots) }
\arguments{
        \item{x}{A binary observation (coded \{0, 1 \} ) or a verification
          object.}
         \item{pred}{A probability prediction on the interval [0,1].  If
	   multiple models are compared, this may be a matrix where each
           column represents a different prediction.}
	\item{thresholds}{Thresholds may be provided. These thresholds
	  will be used to calculate the hit rate ($h$) and false alarm
	  rate ($f$).  If thresholds is NULL, all unique thresholds are
	  used as a threshold. Alternatively, if the number of bins is
	  specified,  thresholds will be calculated using the
	  specified numbers of quantiles. }
%        \item{all.thres}{Should all unique predictions be used as a
%	  threshold? Defaults to FALSE.  By default, n.thres.bin will be
%	used by calculating percentiles for each threshold.  } 
	\item{binormal}{ If TRUE, in addition to the empirical ROC curve, the
  binormal ROC curve will be calculated.  To get a plot draw, plot must
  be either ``binorm'' or ``both''.  }
\item{leg}{Character vector for legend.  If NULL, models are
  labeled  ``Model A", ``Model B",...}

%	\item{n.thres.bins}{Alternatively, the number of bins may be
%	  specified.  Thresholds will then be calculated using the
%	  specified numbers of quantiles.}


	 
	 \item{plot}{Either ``emp'' (default), ``binorm'' or ``both'' to
	   determine which plot is shown.  If set to NULL, a plot is not
	   created}
        \item{plot.thres}{By default, displays the threshold levels on
	  the ROC diagrams.  To surpress these values, set it equal to
	  NULL.}
\item{main}{Title for plot.}
	\item{xlab, ylab}{Plot axes labels.  Defaults to ``Hit Rate''
	  and ``False Alarm Rate'', for the y and x axes respectively.} 
	 \item{\dots}{Additional plotting options.}
       }
       \value{
	 If assigned to an object, the following values are reported.
	 \item{plot.data}{The data used to generate the ROC plots.  This
	   is a array. Column headers are thresholds, PODy, PODn.  Each
	   model is depicted on a separate sheet.}
	 \item{roc.vol}{The areas under the ROC curves.  By default,this
	   is printed on the plots.  Areas and p-values are
	   calculated with and without adjustments for ties along with
	   the p-value for the area.  These
	   values are calculated using \code{\link{roc.area}}.  The
	   fifth column contains the area under the binormal curve, if
	   binormal is selected.}
	 }

       \references{
Mason, I. (1982) ``A model for assessment of weather forecasts,''
\emph{Aust. Met. Mag} \bold{30} (1982) 291-303.  

	 Mason, S.J. and N.E. Graham. (2002) ``Areas beneath the
   relative operating characteristics (ROC) and relative operating
   levels (ROL) curves: Statistical significance and interpretation, ''
   \emph{Q. J. R. Meteorol. Soc.} \bold{128} pp. 2145-2166.  
 
 Swets, John A. (1996) \emph{Signal Detection Theory and ROC Analysis
   in Psychology and Diagnostics}, Lawrence Erlbaum Associates, Inc.
       }
	 \examples{
# Data from Mason and Graham article.

a<- c(0,0,0,1,1,1,0,1,1,0,0,0,0,1,1)
b<- c(.8, .8, 0, 1,1,.6, .4, .8, 0, 0, .2, 0, 0, 1,1)
c<- c(.928,.576, .008, .944, .832, .816, .136, .584, .032, .016, .28, .024, 0, .984, .952)

A<- data.frame(a,b,c)
names(A)<- c("event", "p1", "p2")

## for model with ties
roc.plot(A$event, A$p1)

## for model without ties
roc.plot(A$event, A$p2)

### show binormal curve fit.

roc.plot(A$event, A$p2, binormal = TRUE)

# icing forecast

data(prob.frcs.dat)
A <- verify(prob.frcs.dat$obs, prob.frcs.dat$frcst/100)
plot(A, titl = "AWG Forecast")


# plotting a ``prob.bin'' class object.
obs<- round(runif(100))
pred<- runif(100)

A<- verify(obs, pred, frcst.type = "prob", obs.type = "binary")

roc.plot(A, main = "Test 1", binormal = TRUE)
}
\author{Matt Pocernich <pocernic@rap.ucar.edu>}

       \keyword{file}

\eof
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
% ** Copyright UCAR (c) 1992 - 2004 
% ** University Corporation for Atmospheric Research(UCAR) 
% ** National Center for Atmospheric Research(NCAR) 
% ** Research Applications Program(RAP) 
% ** P.O.Box 3000, Boulder, Colorado, 80307-3000, USA 
% ** 2004/1/7 11:31:8 
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
\name{verify-internal}
\alias{table.stats}
\alias{summary.prob.bin}
\alias{summary.bin.bin}
\alias{summary.cont.cont}
\alias{summary.norm.dist.cont}
\alias{ranked.hist}
\alias{plot.prob.bin}
\alias{plot.cont.cont}
\alias{zzz}
\title{
  Verify internal and secondary functions
}
\description{
 Listed below are either internal functions or secondary functions.
 }
 \usage{
 table.stats(obs, pred)
 summary.prob.bin(object, \dots)
 summary.bin.bin(object, \dots)
 summary.cont.cont(object, \dots)
 summary.norm.dist.cont(object, \dots)
 ranked.hist(frcst, nbins = 10, titl = NULL) 
 plot.prob.bin(x, \dots)
 plot.cont.cont(x, \dots)
 zzz
}
\keyword{internal}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
% ** Copyright UCAR (c) 1992 - 2004 
% ** University Corporation for Atmospheric Research(UCAR) 
% ** National Center for Atmospheric Research(NCAR) 
% ** Research Applications Program(RAP) 
% ** P.O.Box 3000, Boulder, Colorado, 80307-3000, USA 
% ** 2004/1/7 11:31:8 
% *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=* 
\name{verify}
       \alias{verify}
       \title{Verification function}
       \description{Based on the type of inputs, this function
	 calculates a range of verification statistics and skill scores.
       Additionally, it creates a verify  class object that can be
       further analyzed.}
       \usage{
    verify(obs, pred,  tseries= NULL, baseline = NULL, % sample.baseline = FALSE,
           frcst.type = "prob", obs.type = "binary",  thresholds = seq(0,1,0.1) )
       }
       \arguments{
	 \item{obs}{The value with which the verifications are verified.}
	 \item{pred}{Prediction of event.  The prediction may be in the form of the a point
	   prediction or the probability of a forecast.}
	 \item{tseries}{Optional time series vector.  This allows
	   certain types of plots to be made.}
	 \item{baseline}{In meteorology, climatology is the baseline
	   that represents the
	   no-skill forecast.  In other fields this field would
	   differ.  This field is used to calculate certain skill
	   scores.  If left NULL, these statistics are calculated using
	   sample climatology.}
%	 \item{sample.baseline}{Logical indicating whether the data
%	   provided is sample baselinetology or not.}
	 \item{frcst.type}{Forecast type.  Either "prob", "binary", or
	   "cont".  Defaults to "prob"}
	 \item{obs.type}{Observation type.  Either  "binary", or
	   "cont".  Defaults to "binary"}
	 \item{thresholds}{Thresholds to be considered for point
	   forecasts of continuous events.}
       }
       \value{
	 An object of the verify class.  Depending on the type of
	  data used, the following information may be returned.  The
	  following notation is used to describe which values are
	  produced for which type of forecast/observations. (BB =
	  binary/binary, PB = probablistic/binary, CC = continuous/continuous.)   

	  \item{BS}{Brier Score (PB)}
           \item{BSS}{Brier Skill Score(PB)}
	  \item{SS}{Skill Score (BB)}
	  \item{hit.rate}{Hit rate, aka PODy, $h$ (PB)}
	  \item{false.alarm.rate}{False alarm rate, PODn,
	    $f$ (PB)}
	  \item{TS}{Threat Score or Critical Success Index (CSI)(BB) }
          \item{ETS}{Equitable Threat Score (BB)}
	  \item{BIAS}{Bias (BB) }
	  \item{PC}{Percent correct or hit rate (BB)}
	  \item{Cont.Table}{Contingency Table (BB)}
          \item{HSS}{Heidke Skill Score(BB) }
	  \item{KSS}{Kuniper Skill Score (BB)}
	  \item{ME}{Mean error (CC) }
	  \item{MSE}{Mean-squared error (CC)}
	  \item{MAE}{Mean absolute error (CC)}
	 
	}
      }
      \references{
	
  Wilks, D. S. (1995) \emph{Statistical Methods in the Atmospheric Sciences }
  Chapter 7, San Diego: Academic Press.

  WMO Joint WWRP/WGNE Working Group on Verification Website
  
  \url{http://www.bom.gov.au/bmrc/wefor/staff/eee/verif/verif_web_page.html}

World Meteorological Organization Verification Website
  
  \url{http://www.wmo.ch/web/aom/pwsp/Verification.html}
}
	 \examples{
# binary/binary example
obs<- round(runif(100))
pred<- round(runif(100))

A<- verify(obs, pred, frcst.type = "binary", obs.type = "binary")
summary(A)
#  probabilistic/ binary example
pred<- runif(100)
A<- verify(obs, pred, frcst.type = "prob", obs.type = "binary")
summary(A)
# continuous/ continuous example
obs<- rnorm(100)
pred<- rnorm(100)
baseline <- rnorm(100, sd = 0.5) 

A<- verify(obs, pred, baseline = baseline,  frcst.type = "cont", obs.type = "cont")
summary(A)
}

\author{Matt Pocernich <pocernic@rap.ucar.edu>}

       \keyword{file}

\eof
