### Name: bic.surv
### Title: Bayesian Model Averaging for Survival models.
### Aliases: bic.surv bic.surv.data.frame bic.surv.matrix bic.surv.formula
### Keywords: regression survival

### ** Examples


## veteran data
library(survival)
data(veteran)

test.bic.surv<- bic.surv(Surv(time,status) ~ ., data = veteran, factor.type = TRUE)
summary(test.bic.surv, conditional=FALSE, digits=2)
plot(test.bic.surv)

imageplot.bma(test.bic.surv)


## pbc data
data(pbc)
x<- pbc[1:312,]
surv.t<- x$time
cens<- x$status
x<- x[,-c(6,7,10,17,19)]

x$bili<- log(x$bili)
x$alb<- log(x$alb)
x$protime<- log(x$protime)
x$copper<- log(x$copper)
x$sgot<- log(x$sgot)

test.bic.surv<- bic.surv(x, surv.t, cens, factor.type=FALSE, strict=FALSE)
summary(test.bic.surv)




