### Name: bomsoi
### Title: Southern Oscillation Index Data
### Aliases: bomsoi
### Keywords: datasets

### ** Examples
 
plot(ts(bomsoi[, 15:14], start=1900),
     panel=function(y,...)panel.smooth(1900:2001, y,...))

# Check for skewness by comparing the normal probability plots for 
# different a, e.g.
par(mfrow = c(2,3))
for (a in c(50, 100, 150, 200, 250, 300))
qqnorm(log(bomsoi[, "avrain"] - a))
  # a = 250 leads to a nearly linear plot
par(mfrow = c(1,1))

plot(bomsoi$SOI, log(bomsoi$avrain - 250), xlab = "SOI",
     ylab = "log(avrain = 250)")
lines(lowess(bomsoi$SOI)$y, lowess(log(bomsoi$avrain - 250))$y, lwd=2)
  # NB: separate lowess fits against time
lines(lowess(bomsoi$SOI, log(bomsoi$avrain - 250)))

detsoi <- data.frame(
  detSOI = bomsoi[, "SOI"] - lowess(bomsoi[, "SOI"])$y,
  detrain = log(bomsoi$avrain - 250) - lowess(log(bomsoi$avrain - 250))$y)
row.names(detsoi) <- paste(1900:2001)

par(mfrow = c(1,2))  
plot(log(avrain-250) ~ SOI, data = bomsoi, ylab = 
 "log(Average rainfall - 250)")
lines(lowess(bomsoi$SOI, log(bomsoi$avrain-250)))
plot(detrain ~ detSOI, data = detsoi,
  xlab="Detrended SOI", ylab = "Detrended log(Rainfall-250)")
lines(lowess(detsoi$detrain ~ detsoi$detSOI)) 
par(mfrow = c(1,1))



