### Name: angles
### Title: Compute Turning Angles
### Aliases: angles
### Keywords: spatial

### ** Examples

## loads an object of class "traj"
data(puechcirc)
puechcirc

## Gets a part of the trajectory of the wild boar named
## CH93 and draws it
## Also displays the turning angles
toto <- puechcirc[2:5,]
plot(toto$x, toto$y, asp = 1, ylim = c(3158300, 3158550),
     pch = 16,
     main = "Turning angles between\nthree consecutive moves",
     xlab="X", ylab="Y")
lines(toto$x, toto$y)
lines(c(toto$x[2], 700217.6),
      c(toto$y[2], 3158310), lty=2)
lines(c(toto$x[3],700289),
      c(toto$y[3],3158546), lty=2)
ang1x <- c(700234.8, 700231.9, 700231, 700233.7, 700238.8, 700243.2)
ang1y <- c(3158332, 3158336, 3158341, 3158347, 3158350, 3158350)
ang2x <- c(700283.3, 700278.8, 700275.4, 700272.4, 700271.2, 700271.6,
           700274.7)
ang2y <- c(3158522, 3158522, 3158520, 3158517, 3158514, 3158508, 3158504)
lines(ang1x, ang1y)
lines(ang2x, ang2y)
text(700216.1, 3158349, expression(theta[1]), cex=2)
text(700247.7, 3158531, expression(theta[2]), cex=2)
text(c(700301, 700231), c(3158399, 3158487),
     c("Beginning", "End"), pos=4)


## Computation of the turning angles with real data
## on wild boars
plot(puechcirc)
ang <- angles(puechcirc)

## The angles are in the column Angles:
ang[1:4,]




