### Name: as.kasc
### Title: Working with Several Raster Maps
### Aliases: as.kasc kasc getkasc image.kasc print.kasc
### Keywords: programming hplot

### ** Examples


data(puechabon)

## kasc is a list of class kasc
(kasc <- puechabon$kasc)

## Stores two elements of the kasc in objects
## of class asc
(asp <- getkasc(kasc, "Aspect"))
(sl <- getkasc(kasc, "Slope"))

## Displays the slopes on the area (numeric)
image(sl, main = "Aspect", xlab = "Lambert X", ylab = "Lambert Y")

## Aspect is a factor:
## cl is the list of color associated with the levels
## of asp
cl <- colasc(asp, NorthEast = "blue", SouthEast = "red", 
             SouthWest = "orange", NorthWest = "green")
image(asp, clfac = cl, main = "Aspect", xlab = "Lambert X",
      ylab = "Lambert Y")
legend(706500, 3162000, legend=levels(asp), fill=cl, cex=0.7)


## Creation of a new kasc with elevation 
## and slopes
cuicui <- as.kasc(list(Slope = sl, Aspect = asp))

## Displays the kasc object
## with random colors for aspect and grey levels for slopes
image(cuicui)

## with cm.colors for slopes (numeric)
## and cl for aspect (factor)
image(cuicui, col = cm.colors(256), clfac = list(Aspect = cl))

## plots only slope
image(cuicui, "Slope", main="Slope")
## similar to
image(cuicui, 1, main = "Slope")




