### Name: as.sahrlocs
### Title: Exploratory Analysis of Habitat Selection
### Aliases: as.sahrlocs getsahrlocs print.sahrlocs
### Keywords: spatial multivariate

### ** Examples

data(puechabon)
kasc <- puechabon$kasc
locs <-  puechabon$locs

## Computes the home ranges of the animals...
cp <- mcp(locs[,4:5], locs[,1])

## ... and converts it to raster
cprast <- hr.rast(cp, kasc)
locrast <- count.points.id(locs[,4:5], locs[,1], kasc)

## Creation of the sahrlocs object
(sahr <- as.sahrlocs(locrast, cprast, kasc))

## adds information on the monitored animals
age <- factor(tapply(locs[,2], locs[,1], mean))
sex <- factor(tapply(locs[,3], locs[,1], mean))
info <- as.data.frame(cbind(sex, age))
(sahr <- as.sahrlocs(locrast, cprast, kasc, info))

## Gets the "study area" component of the object
toto <- getsahrlocs(sahr)
image(toto)



