### Name: as.traj
### Title: Working with Trajectories in 2D Space
### Aliases: as.traj traj print.traj summary.traj plot.traj getburst
###   traj2df df2traj
### Keywords: spatial

### ** Examples


data(puechabon)
locs <- puechabon$locs
locs[1:4,]

### Conversion of the date to the format POSIX
da <- as.character(locs$Date)
da <- as.POSIXct(strptime(as.character(locs$Date),
               "%y%m%d"))

### Creation of the object of class "traj"
(tr <- as.traj(id = locs$Name, xy = locs[,c("X", "Y")],
               date = da))
summary(tr)
plot(tr)

### Displays on maps of the study area
k <- puechabon$kasc
ele <- getkasc(k, "Elevation")
plot(tr, asc = ele)

### Case with several burst per animal
data(puechcirc)
plot(puechcirc, asc = ele)
plot(puechcirc, asc = ele, perani = FALSE)




