### Name: asc2im
### Title: Conversion of Maps of Class 'asc' and 'im' (Package spatstat)
### Aliases: asc2im im2asc
### Keywords: spatial

### ** Examples

if (require(spatstat)) {
  
#######################
### Conversion asc -> im

  data(puechabon)
  el <- getkasc(puechabon$kasc, "Elevation")
  image(el, main = "An object of class \"asc\"")
  elim <- asc2im(el)
  image(elim, main = "An object of class \"im\"")

#######################
### Conversion im -> asc
  u <- matrix(rnorm(10000), 100, 100)
  haha <- im(u)
  image(haha, main = "class im")
  hihi <- im2asc(haha)
  image(hihi, main = "class asc")

}



