### Name: ascgen
### Title: Creation of Raster Maps
### Aliases: ascgen
### Keywords: spatial

### ** Examples

data(puechabon)
lo <- puechabon$locs[,c("X","Y")]
plot(lo, asp = 1, pch = 16)

## lo contains the relocations of wild boars
rast <- ascgen(lo, cellsize = 100)
image(rast)

## Alternatively, one can specify the size of the square raster map
rast <- ascgen(lo, nrcol = 10)
rast
image(rast)

## can be used for further analyses
## (e.g. correspondence analyses)
locs <- puechabon$locs[, c("Name", "X", "Y")]
o <- count.points.id(locs[,2:3], locs[,1], rast)
image(o)



