### Name: count.points.id
### Title: Number of Points in Each Pixel of a Raster Map
### Aliases: count.points.id count.points
### Keywords: spatial

### ** Examples

data(puechabon)
kasc <- puechabon$kasc
locs <-  puechabon$locs

## Counts the number of relocations of each wild boar
## per pixel of the raster map
(nlocrast <- count.points.id(locs[,4:5], locs[,1], kasc))
image(nlocrast)

## Counts the number of all relocations
## per pixel of the raster map
(nlocrast <- count.points(locs[,c("X","Y")], kasc))
image(nlocrast)




