### Name: domain
### Title: Estimation of the Potential Distribution of a Species
### Aliases: domain
### Keywords: spatial multivariate

### ** Examples


## Preparation of the data
data(puechabon)
kasc <- puechabon$kasc
kasc$Aspect <- NULL
pts <- puechabon$locs[puechabon$locs$Name == "Brock", 4:5]

## View of the data
elevation <- getkasc(kasc, "Elevation")
image(elevation)
points(pts, col = "red", pch = 16)

## Estimation of habitat suitability map
hsm <- domain(kasc, pts)
image(hsm, col = grey((1:256)/256))
contour(hsm, add = TRUE)
## Lighter areas are the most preferred areas

## Potential distribution
hsm <- domain(kasc, pts, type = "potential")
image(elevation, main = "Habitat suitability map")
image(hsm, add = TRUE, col = "orange")
points(pts, col = "red", pch = 16)




