### Name: getcontour
### Title: Computes the Contour Polygon of a Raster Object
### Aliases: getcontour
### Keywords: programming hplot

### ** Examples


data(puechabon)
kasc <- puechabon$kasc

#########################################
## Example with one object:
## Gets the first map of the "kasc" object
## Map of the elevation
elev <- getkasc(kasc, "Elevation")
image(elev)
 
## Get the contour polygon
cpol <- getcontour(elev)

## Draw the polygon
i <- cpol[,2:3]
polygon(i, col = "green", lwd = 2)

#########################################
## Example with two objects:
## home ranges of wild boar

hr <- getsahrlocs(puechabon$sahr, "hr")
u <- getkasc(hr, "Jean")
image(u)

## Get the contour polygons
p <- getcontour(u)
plot(p, lwd = 2)




