### Name: image.asc
### Title: Displays a Color Image of an Object of Class 'asc'
### Aliases: image.asc persp.asc contour.asc plot.asc
### Keywords: hplot

### ** Examples


data(puechabon)

# Case of a continuous variable: the elevation
my.map <- getkasc(puechabon$kasc, "Elevation")
image(my.map, main = "Elevation in Puechabon")
contour(my.map, add = TRUE)

# use of the function plot.asc: adding points on the map
plot(my.map, plot.axes = {points(puechabon$locs[,c("X","Y")])},
     main = "Elevation")

# Case of a factor: the aspect
asp <- getkasc(puechabon$kasc, "Aspect")
cl <- colasc(asp, NorthEast = "blue", SouthEast = "red", 
             SouthWest = "orange", NorthWest = "green")

## graphical display
image(asp, clfac = cl, main = "Aspect", xlab = "Lambert X",
      ylab = "Lambert Y") 
legend(706500, 3162000, legend = levels(asp), fill = cl,
       cex = 0.7)

opar<-par(mar = c(0,0,3,0), bg = "slategray")
persp(my.map, scale = FALSE, box = FALSE, border = NA, shade = 0.75, 
      col = "darkolivegreen3", expand = 2, theta = -60, phi = 30, 
      main = "The topography of Puechabon")
par(opar)




