### Name: import.asc
### Title: Arcview ASCII Raster File Importation And Exportation
### Aliases: import.asc export.asc as.asc asc print.asc
### Keywords: file

### ** Examples

## Not run: 
##D ## Importation of asc files: numeric
##D ## Path of the file to be imported
##D (file1 <-  paste(system.file(package = "adehabitat"),
##D                "ascfiles/Elevation.asc", sep = "/"))
##D 
##D el <- import.asc(file1)
##D image(el)
##D el
##D 
##D ## Importation of asc files: factor
##D (file2 <- paste(system.file(package = "adehabitat"),
##D               "ascfiles/Aspect.asc", sep = "/"))
##D (levelfile <- paste(system.file(package = "adehabitat"),
##D               "ascfiles/Aspect.txt", sep = "/"))
##D asp <- import.asc(file2, lev = levelfile, type = "factor")
##D image(asp)
##D asp
##D 
##D ## map of white noise
##D wafwaf <- matrix(rnorm(10000), 100, 100)
##D wafwaf <- as.asc(wafwaf)
##D image(wafwaf)
##D 
##D ## exportation of a map
##D export.asc(wafwaf, "foo.asc")
##D 
##D ## remove the created file:
##D file.remove("foo.asc")
## End(Not run)



