### Name: kasc2df
### Title: Conversion of Objects of Class kasc
### Aliases: kasc2df df2kasc
### Keywords: multivariate NA

### ** Examples

data(puechabon)
kasc <- puechabon$kasc

# Display the kasc object
image(kasc)

# Preparation for Principal component analysis
x <- kasc2df(kasc)
x$tab <- x$tab[, (names(x$tab) != "Aspect")]

# Principal component analysis
ana <- dudi.pca(x$tab, scannf = FALSE)

s.arrow(ana$co)
s.label(ana$li, clab = 0)

## Map of the scores of the rows
scores <- df2kasc(ana$li, x$index, kasc)
image(scores)



