### Name: kasc2spixdf
### Title: Conversion of maps from/to the package "sp"
### Aliases: kasc2spixdf asc2spixdf spixdf2kasc area2sr sr2area attsr2area
###   traj2spdf traj2sldf
### Keywords: hplot

### ** Examples

## Not run: 
##D if (require(sp) {
##D 
##D #########################################
##D ##
##D ## Conversion kasc -> SpatialPixelsDataFrame
##D ##
##D 
##D data(puechabon)
##D toto <- kasc2spixdf(puechabon$kasc)
##D image(toto)
##D summary(toto)
##D 
##D #### and conversely
##D toto <- spixdf2kasc(toto)
##D image(toto)
##D hist(toto)
##D 
##D data(meuse.grid)
##D m <- SpatialPixelsDataFrame(points = meuse.grid[c("x", "y")],
##D                            data = meuse.grid)
##D i <- spixdf2kasc(m)
##D image(i)
##D 
##D ### conversion asc -> SpatialPixelsDataFrame
##D cuicui <- asc2spixdf(getkasc(toto,1))
##D image(cuicui)
##D 
##D #########################################
##D ##
##D ## Conversion area -> SpatialRings
##D ##
##D 
##D data(elec88)
##D ar <- as.area(elec88$area)
##D plot(ar)
##D toto <- area2sr(ar)
##D plot(toto)
##D 
##D #########################################
##D ##
##D ## Conversion SpatialRings -> area
##D ##
##D 
##D ## First create an object of class "SpatialRingsDataFrame"
##D data(ncshp)
##D nc1 <- as.SpatialRings.Shapes(nc.shp$Shapes, as.character(nc.shp$att.data$FIPS))
##D plotSpatialRings(nc1)
##D df <- nc.shp$att.data
##D rownames(df) <- as.character(nc.shp$att.data$FIPS)
##D ncSRDF <- SpatialRingsDataFrame(nc1, df)
##D 
##D ## and then conversion:
##D coincoin <- sr2area(ncSRDF)
##D ## please note the warnings
##D 
##D plot(coincoin)
##D ## gets the attributes
##D haha <- attsr2area(ncSRDF)
##D area.plot(coincoin, values = df$SID74/df$BIR74)
##D 
##D #########################################
##D ##
##D ## Conversion traj -> SpatialPointsDataFrame
##D ##
##D 
##D data(puechcirc)
##D plot(puechcirc)
##D 
##D toto <- traj2spdf(puechcirc)
##D plot(toto)
##D 
##D #########################################
##D ##
##D ## Conversion traj -> SpatialLinesDataFrame
##D ##
##D 
##D data(puechcirc)
##D plot(puechcirc)
##D 
##D toto <- traj2sldf(puechcirc)
##D plot(toto)
##D 
##D }
## End(Not run)



