### Name: labcon
### Title: Labelling Connected Features
### Aliases: labcon
### Keywords: spatial

### ** Examples

  data(puechabon)
  hr <- getsahrlocs(puechabon$sahr, "hr")
  u <- getkasc(hr, "Jean")
  image(u)

  ## numbering of the connected components
  p <- labcon(u)
  nlevels(p)
  image(p)

  ##  stores the first component
  c1 <- p
  c1[c1 != 1] <- NA
  image(c1)

  ##  stores the second component
  c2 <- p
  c2[c2 != 2] <- NA
  image(c2)



