### Name: mcp.rast
### Title: Converts a Polygon to Raster
### Aliases: mcp.rast
### Keywords: spatial

### ** Examples

data(puechabon)
toto <- puechabon$kasc
loc <- puechabon$locs

## gets the coordinates of the relocations for the wild boar #1
wb1 <- loc[loc$Name == "Chou",]
wb1 <- cbind(wb1$X, wb1$Y)
nbpol <- chull(wb1)
xycoord <- wb1[nbpol,]

## rasterization of wb1
tutu <- mcp.rast(xycoord, toto)
image(tutu)

polygon(xycoord, lwd = 2)



