### Name: morphology
### Title: Morphology: Erosion or Dilatation of Features on a Raster Map
### Aliases: morphology
### Keywords: spatial

### ** Examples

data(puechabon)
a <- getkasc(puechabon$kasc,"Elevation")

## dilatation
toto1 <- morphology(a, operation = "dilate", nt = 1)
toto2 <- morphology(a, operation = "dilate", nt = 2)
toto3 <- morphology(a, operation = "dilate", nt = 3)
toto5 <- morphology(a, operation = "dilate", nt = 5)
image(toto5, col = "red")
image(toto3, add = TRUE, col = "orange")
image(toto2, add = TRUE, col = "yellow")
image(toto1, add = TRUE, col = "green")
image(a, add = TRUE)

## erosion
image(a, col = 1)
for (i in 1:19) {
  toto <- morphology(a, operation = "erode", nt = i)
  image(toto, add = TRUE, col = palette()[(i+1)%%8])
}




