### Name: predict.enfa
### Title: Habitat Suitability Maps Built from the ENFA
### Aliases: predict.enfa
### Keywords: multivariate

### ** Examples

## Not run: 
##D data(lynxjura)
##D 
##D map <- lynxjura$map
##D 
##D ## We keep only "wild" indices.
##D tmp <- lynxjura$loc[,4] != "D"
##D locs <- lynxjura$locs[tmp, c("X","Y")]
##D dataenfa1 <- data2enfa(map, locs[tmp, c("X","Y")])
##D 
##D (enfa1 <- enfa(dataenfa1$tab, dataenfa1$pr,
##D                scannf = FALSE))
##D 
##D ## Compute the prediction
##D pred <- predict(enfa1, dataenfa1$index, dataenfa1$attr)
##D image(pred)
##D contour(pred, col="green", add=T)
##D points(locs, col = "red", pch = 16)
##D ## Lighter areas are the most preferred areas
## End(Not run)



