### Name: setmask
### Title: Applies a Mask on Objects of Class 'asc' or 'kasc'
### Aliases: setmask
### Keywords: spatial

### ** Examples


data(puechabon)
kasc <- puechabon$kasc
image(kasc)
elev <- getkasc(kasc, "Elevation")
slope <- getkasc(kasc, "Slope")

## ma is the mask: only areas with elevation > 250 m
## are kept
ma <- elev
ma[ma < 250] <- NA
ma <- getascattr(elev, ma)
image(ma)

## The mask is applied on maps of slope
slp <- setmask(slope, ma)
image(slp)

## The mask is applied on all maps in kasc
im <- setmask(kasc, ma)
image(im)




