### Name: intervals.snr
### Title: Calculate Predictions and Approximate Posterior Standard
###   Deviations for Spline Estimates From a snr Object
### Aliases: intervals.snr
### Keywords: file

### ** Examples


data(CO2)
options(contrasts=rep("contr.treatment", 2))  

## get start values  
co2.fit1 <- nlme(uptake~exp(a1)*(1-exp(-exp(a2)*(conc-a3))), 
                 fixed=list(a1+a2~Type*Treatment,a3~1), 
                 random=a1~1, groups=~Plant, 
                 start=c(log(30),0,0,0,log(0.01),0,0,0,50),
                 data=CO2)

M <- model.matrix(~Type*Treatment, data=CO2)[,-1]

## fit a SNR model
co2.fit2 <- snr(uptake~exp(a1)*f(exp(a2)*(conc-a3)),
                func=f(u)~list(~I(1-exp(-u))-1,lspline(u, type="exp")),
                params=list(a1~M-1, a3~1, a2~Type*Treatment),
                start=list(params=co2.fit1$coe$fixed[c(2:4,9,5:8)]), data=CO2)

p.co2.fit2<- intervals(co2.fit2, newdata=data.frame(u=seq(0,10,len=50)))




