mouse.c              package:bootstrap              R Documentation

_E_x_p_e_r_i_m_e_n_t_s _w_i_t_h _m_o_u_s_e

_D_e_s_c_r_i_p_t_i_o_n:

     A small randomized experiment were done with 16 mouse, 7 to
     treatment group and 9 to control group. Treatment was intended to
     prolong survival  after a test surgery.

_U_s_a_g_e:

     data(mouse.c)

_F_o_r_m_a_t:

     The format is: num [1:9] 52 104 146 10 50 31 40 27 46

_D_e_t_a_i_l_s:

     The treatment group is is dataset 'mouse.t'. 'mouse.c' is the
     control group. The book uses this example to illustrate 
     bootstrapping a sample mean. Measurement unit is days of survival
     following surgery.

_S_o_u_r_c_e:

     Efron, B. and Tibshirani, R. (1993) An Introduction to the
     Bootstrap.  Chapman and Hall, New York, London.

_E_x_a_m_p_l_e_s:

     str(mouse.c)
     if(interactive())par(ask=TRUE)
     stripchart(list(treatment=mouse.t, control=mouse.c))
     cat("bootstrapping the difference of means, treatment - control:\n")
     cat("bootstrapping is done independently for the two groups\n")
     mouse.boot.c <- bootstrap(mouse.c, 2000, mean)
     mouse.boot.t <- bootstrap(mouse.t, 2000, mean)
     mouse.boot.diff <- mouse.boot.t$thetastar - mouse.boot.c$thetastar
     hist(mouse.boot.diff)
     abline(v=0, col="red2")
     sd(mouse.boot.diff)

