### Name: atvpar
### Title: Parametric Dependence Functions of Trivariate Extreme Value
###   Models
### Aliases: atvpar
### Keywords: distribution

### ** Examples

atvpar(dep = 0.5, model = "log")
s3pts <- matrix(rexp(30), nrow = 10, ncol = 3)
s3pts <- s3pts/rowSums(s3pts)
atvpar(s3pts, dep = 0.5, model = "log")
## Not run: atvpar(dep = 0.05, model = "log", plot = TRUE, blty = 1)
atvpar(dep = 0.95, model = "log", plot = TRUE, lower = 0.94)

asy <- list(.4, .1, .6, c(.3,.2), c(.1,.1), c(.4,.1), c(.2,.3,.2))
atvpar(s3pts, dep = 0.15, asy = asy, model = "alog")
atvpar(dep = 0.15, asy = asy, model = "al", plot = TRUE, lower = 0.7)



