### Name: locfit
### Title: Local Regression, Likelihood and Density Estimation.
### Aliases: locfit
### Keywords: smooth

### ** Examples

# fit and plot a univariate local regression
data(ethanol)
fit <- locfit(NOx~E,data=ethanol)
plot(fit,get.data=TRUE)

# a bivariate local regression with smaller smoothing parameter
fit <- locfit(NOx~E+C, data=ethanol, scale=0, alpha=0.5)
plot(fit)

# density estimation
data(geyser, package="locfit")
fit <- locfit(~geyser, alpha=c(0.1,0.8))
plot(fit,get.data=TRUE)



