### Name: gclust.boxstats
### Title: Plot Statistics Associated with Graph Clusters
### Aliases: gclust.boxstats
### Keywords: hplot

### ** Examples

#Create some random graphs
g<-rgraph(10,20,tprob=c(rbeta(10,15,2),rbeta(10,2,15)))

#Find the Hamming distances between them
g.h<-hdist(g)

#Cluster the graphs via their Hamming distances
g.c<-hclust(as.dist(g.h))

#Now display boxplots of density by cluster for a two cluster solution
gclust.boxstats(g.c,2,gden(g))



