### Name: netcancor
### Title: Canonical Correlation for Labeled Graphs
### Aliases: netcancor
### Keywords: multivariate math graphs

### ** Examples

#Generate a valued seed structure
cv<-matrix(rnorm(100),nrow=10,ncol=10)
#Produce two sets of valued graphs
x<-array(dim=c(3,10,10))
x[1,,]<-3*cv+matrix(rnorm(100,0,0.1),nrow=10,ncol=10)
x[2,,]<--1*cv+matrix(rnorm(100,0,0.1),nrow=10,ncol=10)
x[3,,]<-x[1,,]+2*x[2,,]+5*cv+matrix(rnorm(100,0,0.1),nrow=10,ncol=10)
y<-array(dim=c(2,10,10))
y[1,,]<--5*cv+matrix(rnorm(100,0,0.1),nrow=10,ncol=10)
y[2,,]<--2*cv+matrix(rnorm(100,0,0.1),nrow=10,ncol=10)
#Perform a canonical correlation analysis
nc<-netcancor(y,x,reps=100)
summary(nc)



