### Name: rgws
### Title: Draw From the Watts-Strogatz Rewiring Model
### Aliases: rgws rewire.ws rewire.ud
### Keywords: distribution graphs

### ** Examples


#Generate Watts-Strogatz graphs, w/increasing levels of rewiring
gplot(rgws(1,100,1,2,0))     #No rewiring
gplot(rgws(1,100,1,2,0.01))  #1
gplot(rgws(1,100,1,2,0.05))  #5
gplot(rgws(1,100,1,2,0.1))   #10
gplot(rgws(1,100,1,2,1))     #100

#Start with a simple graph, then rewire it
g<-matrix(0,50,50)
g[1,]<-1; g[,1]<-1    #Create a star
gplot(g)
gplot(rewire.ws(g,0.05))  #5




