EBImoran.mc              package:spdep              R Documentation

_P_e_r_m_u_t_a_t_i_o_n _t_e_s_t _f_o_r _e_m_p_i_r_i_c_a_l _B_a_y_e_s _i_n_d_e_x

_D_e_s_c_r_i_p_t_i_o_n:

     An empirical Bayes index modification of Moran's I for testing for
     spatial autocorrelation in a rate, typically the number of
     observed cases in a population at risk. The index value is tested
     by using nsim random permutations of the index for the given
     spatial weighting scheme, to establish the rank of the observed
     statistic in relation to the nsim simulated values.

_U_s_a_g_e:

     EBImoran.mc(n, x, listw, nsim, zero.policy = FALSE, 
      alternative = "greater", spChk=NULL)

_A_r_g_u_m_e_n_t_s:

       n: a numeric vector of counts of cases the same length as the
          neighbours list in listw

       x: a numeric vector of populations at risk the same length as
          the neighbours list in listw

   listw: a 'listw' object created for example by 'nb2listw'

    nsim: number of permutations

zero.policy: if TRUE assign zero to the lagged value of zones without
          neighbours, if FALSE assign NA

alternative: a character string specifying the alternative hypothesis,
          must be one of "greater" (default), or "less"

   spChk: should the data vector names be checked against the spatial
          objects for identity integrity, TRUE, or FALSE, default NULL
          to use 'get.spChkOption()'

_D_e_t_a_i_l_s:

     The statistic used is (m is the number of observations):

   EBI = (n sum_i sum_j w_ij z_i z_ji) / (S0 sum_i (z_i - zbar)^2)

     where:

                     z_i = (p_i - b) / sqrt(v_i)

     and:

                           p_i = n_i / x_i


                         v_i = a + (b / x_i)


                        sum_i n_i / sum_i x_i


                    a = s^2 - b / (sum_i x_i / m)


               s^2 = sum_i x_i (p_i - b)^2 / sum_i x_i

_V_a_l_u_e:

     A list with class 'htest' and 'mc.sim' containing the  following
     components: 

statistic: the value of the observed Moran's I.

parameter: the rank of the observed Moran's I.

 p.value: the pseudo p-value of the test.

alternative: a character string describing the alternative hypothesis.

  method: a character string giving the method used.

data.name: a character string giving the name(s) of the data, and the
          number of simulations.

     res: nsim simulated values of statistic, final value is observed
          statistic

       z: a numerical vector of Empirical Bayes indices as z above

_A_u_t_h_o_r(_s):

     Roger Bivand Roger.Bivand@nhh.no

_R_e_f_e_r_e_n_c_e_s:

     Assuno RM, Reis EA 1999 A new proposal to adjust Moran's I for
     population density. Statistics in Medicine 18, pp. 2147-2162

_S_e_e _A_l_s_o:

     'moran', 'moran.mc', 'EBest'

_E_x_a_m_p_l_e_s:

     data(nc.sids)
     EBImoran.mc(spNamedVec("SID74", nc.sids), spNamedVec("BIR74", nc.sids),
      nb2listw(ncCC89.nb, style="B", zero.policy=TRUE), nsim=999,
      zero.policy=TRUE)
     sids.p <- nc.sids$SID74 / nc.sids$BIR74
     names(sids.p) <- rownames(nc.sids)
     moran.mc(sids.p, nb2listw(ncCC89.nb, style="B", zero.policy=TRUE),
      nsim=999, zero.policy=TRUE)

