joincount.mc              package:spdep              R Documentation

_P_e_r_m_u_t_a_t_i_o_n _t_e_s_t _f_o_r _s_a_m_e _c_o_l_o_u_r _j_o_i_n _c_o_u_n_t _s_t_a_t_i_s_t_i_c_s

_D_e_s_c_r_i_p_t_i_o_n:

     A permutation test for same colour join count statistics
     calculated by using nsim random permutations of fx for the given
     spatial weighting scheme, to establish the ranks of the observed
     statistics (for each colour) in relation to the nsim simulated
     values.

_U_s_a_g_e:

     joincount.mc(fx, listw, nsim, zero.policy=FALSE, alternative="greater", spChk=NULL)

_A_r_g_u_m_e_n_t_s:

      fx: a factor of the same length as the neighbours and weights
          objects in listw

   listw: a 'listw' object created for example by 'nb2listw'

    nsim: number of permutations

zero.policy: if TRUE assign zero to the lagged value of zones without
          neighbours, if FALSE assign NA

alternative: a character string specifying the alternative hypothesis,
          must be one of "greater" (default), or "less".

   spChk: should the data vector names be checked against the spatial
          objects for identity integrity, TRUE, or FALSE, default NULL
          to use 'get.spChkOption()'

_V_a_l_u_e:

     A list with class 'jclist' of lists with class 'htest' and
     'mc.sim' for each of the k colours containing the following
     components: 

statistic: the value of the observed statistic.

parameter: the rank of the observed statistic.

  method: a character string giving the method used.

data.name: a character string giving the name(s) of the data.

 p.value: the pseudo p-value of the test.

alternative: a character string describing the alternative hypothesis.

estimate: the mean and variance of the simulated distribution.

     res: nsim simulated values of statistic, the final element is the
          observed statistic

_A_u_t_h_o_r(_s):

     Roger Bivand Roger.Bivand@nhh.no

_R_e_f_e_r_e_n_c_e_s:

     Cliff, A. D., Ord, J. K. 1981 Spatial processes, Pion, p. 63-5.

_S_e_e _A_l_s_o:

     'joincount.test'

_E_x_a_m_p_l_e_s:

     data(oldcol)
     HICRIME <- cut(COL.OLD$CRIME, breaks=c(0,35,80), labels=c("low","high"))
     names(HICRIME) <- rownames(COL.OLD)
     joincount.mc(HICRIME, nb2listw(COL.nb, style="B"), nsim=99)
     joincount.test(HICRIME, nb2listw(COL.nb, style="B"))

