### Name: knearneigh
### Title: K nearest neighbours for spatial weights
### Aliases: knearneigh
### Keywords: spatial

### ** Examples

data(columbus)
col.knn <- knearneigh(coords, k=4)
library(maptools)
plot(polys, border="grey", forcefill=FALSE)
plot(knn2nb(col.knn), coords, add=TRUE)
title(main="K nearest neighbours, k = 4")
data(state)
us48.fipsno <- read.geoda(system.file("etc/weights/us48.txt",
 package="spdep")[1])
if (as.numeric(paste(version$major, version$minor, sep="")) < 19) {
 m50.48 <- match(us48.fipsno$"State.name", state.name)
} else {
 m50.48 <- match(us48.fipsno$"State_name", state.name)
}
xy <- as.matrix(as.data.frame(state.center))[m50.48,]
llk4.nb <- knn2nb(knearneigh(xy, k=4, lonlat=FALSE))
gck4.nb <- knn2nb(knearneigh(xy, k=4, lonlat=TRUE))
plot(llk4.nb, xy)
plot(diffnb(llk4.nb, gck4.nb), xy, add=TRUE, col="red", lty=2)
title(main="Differences between Euclidean and Great Circle k=4 neighbours")
summary(llk4.nb, xy, lonlat=TRUE)
summary(gck4.nb, xy, lonlat=TRUE)



