### Name: localmoran.sad
### Title: Saddlepoint approximation of local Moran's Ii tests
### Aliases: localmoran.sad listw2star print.summary.localmoransad
###   summary.localmoransad print.localmoransad as.data.frame.localmoransad
### Keywords: spatial

### ** Examples

data(eire)
e.lm <- lm(OWNCONS ~ ROADACC, data=eire.df)
e.locmor <- summary(localmoran.sad(e.lm, eire.nb, select=1:nrow(eire.df)))
e.locmor
mean(e.locmor[,1])
lm.morantest(e.lm, nb2listw(eire.nb))
hist(e.locmor[,"Pr. (Sad)"])
e.wlm <- lm(OWNCONS ~ ROADACC, data=eire.df, weights=RETSALE)
e.locmorw1 <- summary(localmoran.sad(e.wlm, eire.nb, select=1:nrow(eire.df), resfun=weighted.residuals))
e.locmorw1
e.locmorw2 <- summary(localmoran.sad(e.wlm, eire.nb, select=1:nrow(eire.df), resfun=rstudent))
e.locmorw2
e.errorsar <- errorsarlm(OWNCONS ~ ROADACC, data=eire.df,
 listw=nb2listw(eire.nb))
e.errorsar
e.clocmor <- summary(localmoran.sad(e.errorsar, eire.nb, select=1:nrow(eire.df)))
e.clocmor
hist(e.clocmor[,"Pr. (Sad)"])



