### Name: poly2nb
### Title: Construct neighbours list from polygon list
### Aliases: poly2nb
### Keywords: spatial

### ** Examples

data(columbus)
xx <- poly2nb(polys)
dxx <- diffnb(xx, col.gal.nb)
library(maptools)
plot(polys, border="grey", forcefill=FALSE)
plot(col.gal.nb, coords, add=TRUE)
plot(dxx, coords, add=TRUE, col="red")
title(main="Differences (red) in Columbus GAL weights (black)\nand polygon generated queen weights")
xxx <- poly2nb(polys, queen=FALSE)
dxxx <- diffnb(xxx, col.gal.nb)
plot(polys, border = "grey", forcefill=FALSE)
plot(col.gal.nb, coords, add = TRUE)
plot(dxxx, coords, add = TRUE, col = "red")
title(main="Differences (red) in Columbus GAL weights (black)\nand polygon generated rook weights")
cards <- card(xx)
maxconts <- which(cards == max(cards))
if(length(maxconts) > 1) maxconts <- maxconts[1]
fg <- rep("grey", length(polys))
fg[maxconts] <- "red"
fg[xx[[maxconts]]] <- "green"
plot(polys, col=fg, forcefill=FALSE)
title(main="Region with largest number of contiguities")



