### Name: used.cars
### Title: US 1960 used car prices
### Aliases: used.cars usa48.nb
### Keywords: datasets

### ** Examples

data(used.cars)
moran.test(spNamedVec("price.1960", used.cars), nb2listw(usa48.nb))
moran.plot(spNamedVec("price.1960", used.cars), nb2listw(usa48.nb),
  labels=rownames(used.cars))
uc.lm <- lm(price.1960 ~ tax.charges, data=used.cars)
summary(uc.lm)
lm.morantest(uc.lm, nb2listw(usa48.nb))
lm.morantest.sad(uc.lm, nb2listw(usa48.nb))
lm.LMtests(uc.lm, nb2listw(usa48.nb))
uc.err <- errorsarlm(price.1960 ~ tax.charges, data=used.cars,
  nb2listw(usa48.nb), tol.solve=1.0e-13, tol.opt=.Machine$double.eps^0.3)
summary(uc.err)
uc.lag <- lagsarlm(price.1960 ~ tax.charges, data=used.cars,
  nb2listw(usa48.nb), tol.solve=1.0e-13, tol.opt=.Machine$double.eps^0.3)
summary(uc.lag)
uc.lag1 <- lagsarlm(price.1960 ~ 1, data=used.cars,
  nb2listw(usa48.nb), tol.solve=1.0e-13, tol.opt=.Machine$double.eps^0.3)
summary(uc.lag1)
uc.err1 <- errorsarlm(price.1960 ~ 1, data=used.cars,
  nb2listw(usa48.nb), tol.solve=1.0e-13, tol.opt=.Machine$double.eps^0.3)
summary(uc.err1)



