### Name: tweedie.profile
### Title: Tweedie Distributions: mle estimation of p
### Aliases: tweedie.profile
### Keywords: models

### ** Examples

library(statmod) # Needed to use  tweedie.profile
# Generate some fictitious data
test.data <- rgamma(n=200, scale=1, shape=1)
# The gamma is a Tweedie distribution with power=2;
# let's see if the profile plot shows this
out <- tweedie.profile( test.data ~1, p.vec=seq(1.7, 2.3, length=10),
       do.plot=TRUE, method="interpolation", smooth=TRUE, do.ci=TRUE)
# And plot the points to see how the smooth went
points( out$p, out$L)



