tweedie.profile           package:tweedie           R Documentation

_T_w_e_e_d_i_e _D_i_s_t_r_i_b_u_t_i_o_n_s: _m_l_e _e_s_t_i_m_a_t_i_o_n _o_f _p

_D_e_s_c_r_i_p_t_i_o_n:

     Maximum likelihood estimation of the Tweedie index parameter
     power.

_U_s_a_g_e:

     tweedie.profile(formula, p.vec, smooth=FALSE, do.plot=FALSE, do.ci=smooth,
     eps=1/6, do.points=do.plot, method="series", conf.level=0.95, 
     phi.method=ifelse(method == "saddlepoint", "saddlepoint", "mle"))

_A_r_g_u_m_e_n_t_s:

 formula: a formula expression as for other regression models and
          generalized linear models,  of the form 'response ~
          predictors'.  For details,  see the documentation for 'lm', 
          'glm' and 'formula'

   p.vec: a vector of 'p' values for consideration. The values must all
          be larger than one (if the response variable has exact zeros,
          the values must all be between one and two). See the DETAILS
          section below for further details.

  smooth: logical flag. If 'TRUE', a spline is fitted to the data to
          smooth the profile likelihood plot. If 'FALSE' (the default),
          no smoothing is used  (and the function is quicker). *Note*
          that 'p.vec' must contain _at least five points_ for
          smoothing to be allowed.

 do.plot: logical flag. If 'TRUE', a plot of the profile likelihood is
          produce. If 'FALSE' (the default), no plot is produced.

   do.ci: logical flag. If 'TRUE', the nominal 100*'conf.level' is
          computed. If 'FALSE', the confidence interval is not
          computed. By default, 'do.ci' is the same value as 'smooth',
          since a confidence interval will only be accurate if
          smoothing has been performed. Indeed, if 'smooth=FALSE',
          confidence intervals are never computed and 'do.ci' is forced
          to 'FALSE' if it is given as 'TRUE'.

     eps: the offset in computing the variance function. The default is
          'eps=1/6' (as suggested by Nelder and Pregibon, 1987). Note
          'eps' is ignored unless the  'method="saddlepoint"' as it
          makes no sense.

do.points: plot the points on the plot where the (log-) likelihood is
          computed for the given values of 'p'; defaults to the same
          value as 'do.plot'

  method: the method for computing the (log-) likelihood. One of
          '"series"' (the default), '"inversion"', '"interpolation"' or
          '"saddlepoint"'. If there are any troubles using this
          function, often a change of method will fix the problem. Note
          that 'method="saddlepoint"' is only an approximate method for
          computing the (log-) likelihood. Using
          'method="interpolation"' may produce a jump in the profile
          likelihood as it changes computational regimes.

conf.level: the confidence level for the computation of the nominal
          confidence interval. The default is 'conf.level=0.95'.

phi.method: the method for estimating 'phi', one of '"saddlepoint"' or
          '"mle"'. A maximum likelihood estimate is used unless
          'method="saddlepoint"', when the saddlepoint approximation
          method is used. Note that using  'phi.method="saddlepoint"'
          is equivalent to using the mean deviance estimator of 'phi'. 

_D_e_t_a_i_l_s:

     For each value in 'p.vec', the function computes an estimate of
     'phi' and then computes the value of the log-likelihood for these
     parameters. The plot of the log-likelihood against 'p.vec'  allows
     the maximum likelihood value of 'p' to be found. Once the value of
     'p' is found, the distribution within the class of Tweedie
     distribution is identified.

_V_a_l_u_e:

     A list containing the components: 'y' and 'x' (such that
     'plot(x,y)' (partially) recreates the profile likelihood plot);
     'ht' (the height of the nominal confidence interval); 'L' (the
     estimate of the (log-) likelihood at each given value of 'p'); 'p'
     (the 'p'-values used); 'p.max' (the estimate of the mle of 'p');
     'L.max' (the estimate of the (log-) likelihood at 'p.max'); 'phi'
     (the estimate of 'phi' at 'p.max'); 'ci' (the lower and upper
     limits of the confidence interval for 'p'); 'method' (the method
     used).

_N_o_t_e:

     The estimates of 'p' and 'phi' are printed. The result is printed
     invisibly.

     If the response variable has any exact zeros, the values in
     'p.vec' must all be between one and two.

     The function is sometimes unstable and may fail. It may also be
     very slow. One solution is to change the method. The default is
     'method="series"' (the default); then try 'method="inversion"',
     'method="interpolation"' and 'method="saddlepoint"' in that order.
     Note that  'method="saddlepoint"' is an approximate method only.
     Also make sure the values in 'p.vec' are suitable for the data  
     (see above paragraph).

     It is recommended that for the first use with a data set, use
     'p.vec' with only a small number of values and set 'smooth=FALSE',
     'do.ci=FALSE'. If this is successful, a larger vector 'p.vec' and
     smoothing can be used.

_A_u_t_h_o_r(_s):

     Peter Dunn (dunn@usq.edu.au)

_R_e_f_e_r_e_n_c_e_s:

     Dunn, Peter K and Smyth, Gordon K (2001). Tweedie family
     densities: methods of evaluation. _Proceedings of the 16th
     International Workshop on Statistical Modelling_, Odense, Denmark,
     2-6 July

     Jorgensen, B. (1987). Exponential dispersion models. _Journal of
     the Royal Statistical Society_, B, *49*, 127-162.

     Jorgensen, B. (1997). _Theory of Dispersion Models_. Chapman and
     Hall, London.

     Nelder, J. A. and Pregibon, D. (1987). An extended
     quasi-likelihood function. _Biometrika_ *74*(2), 221-232.

     Tweedie, M. C. K. (1984). An index which distinguishes between
     some important exponential families. _Statistics: Applications and
     New Directions. Proceedings of the Indian Statistical Institute
     Golden Jubilee International Conference_ (Eds. J. K. Ghosh and J.
     Roy), pp. 579-604. Calcutta: Indian Statistical Institute.

_S_e_e _A_l_s_o:

     'dtweedie' 'dtweedie.saddle'

_E_x_a_m_p_l_e_s:

     library(statmod) # Needed to use  tweedie.profile
     # Generate some fictitious data
     test.data <- rgamma(n=200, scale=1, shape=1)
     # The gamma is a Tweedie distribution with power=2;
     # let's see if the profile plot shows this
     out <- tweedie.profile( test.data ~1, p.vec=seq(1.7, 2.3, length=10),
            do.plot=TRUE, method="interpolation", smooth=TRUE, do.ci=TRUE)
     # And plot the points to see how the smooth went
     points( out$p, out$L)

