### Name: Bundesliga
### Title: Ergebnisse der Fussball-Bundesliga
### Aliases: Bundesliga
### Keywords: datasets

### ** Examples

data(Bundesliga)

## independence of home and away goals
tore95 <- xtabs(~ HomeGoals + AwayGoals, data = Bundesliga,
                subset = Year == 1995)
tore95
mosaic(tore95, gp = shading_max)

## number of goals per game poisson distributed?
ntore1 <- xtabs(~ HomeGoals, data = Bundesliga, subset = Year == 1995)
ntore2 <- xtabs(~ AwayGoals, data = Bundesliga, subset = Year == 1995)
ntore3 <- table(apply(subset(Bundesliga, Year == 1995)[,3:4], 1, sum))

gf1 <- goodfit(ntore1)
gf2 <- goodfit(ntore2)
gf3 <- goodfit(ntore3)

summary(gf1)
summary(gf2)
summary(gf3)
plot(gf1)
plot(gf2)
plot(gf3)

Ord_plot(ntore1)
distplot(ntore1)



