### Name: oddsratio
### Title: (Log) Odds Ratios
### Aliases: oddsratio print.oddsratio summary.oddsratio confint.oddsratio
###   print.summary.oddsratio plot.oddsratio
### Keywords: category

### ** Examples

## load Coal Miners data
data(CoalMiners)

## compute log odds ratios
lor <- oddsratio(CoalMiners)
lor

## summary with z tests
summary(lor)

## confidence intervals
confint(lor)

## visualization
plot(lor,
     xlab = "Age Group",
     main = "Breathelessness and Wheeze in Coal Miners")

## add quadratic model
g <- seq(25, 60, by = 5)
m <- lm(lor ~ g + I(g^2))
lines(fitted(m), col = "red")



